/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.sink;

import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.base.sink.AsyncSinkBaseBuilder;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseSink;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseSinkElementConverter;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.services.firehose.model.Record;

@PublicEvolving
public class KinesisFirehoseSinkBuilder<InputT>
extends AsyncSinkBaseBuilder<InputT, Record, KinesisFirehoseSinkBuilder<InputT>> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 500;
    private static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS = 50;
    private static final int DEFAULT_MAX_BUFFERED_REQUESTS = 10000;
    private static final long DEFAULT_MAX_BATCH_SIZE_IN_B = 0x400000L;
    private static final long DEFAULT_MAX_TIME_IN_BUFFER_MS = 5000L;
    private static final long DEFAULT_MAX_RECORD_SIZE_IN_B = 1024000L;
    private static final boolean DEFAULT_FAIL_ON_ERROR = false;
    private static final Protocol DEFAULT_HTTP_PROTOCOL = Protocol.HTTP1_1;
    private Boolean failOnError;
    private String deliveryStreamName;
    private Properties firehoseClientProperties;
    private SerializationSchema<InputT> serializationSchema;

    KinesisFirehoseSinkBuilder() {
    }

    public KinesisFirehoseSinkBuilder<InputT> setDeliveryStreamName(String deliveryStreamName) {
        this.deliveryStreamName = deliveryStreamName;
        return this;
    }

    public KinesisFirehoseSinkBuilder<InputT> setSerializationSchema(SerializationSchema<InputT> serializationSchema) {
        this.serializationSchema = serializationSchema;
        return this;
    }

    public KinesisFirehoseSinkBuilder<InputT> setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public KinesisFirehoseSinkBuilder<InputT> setFirehoseClientProperties(Properties firehoseClientProperties) {
        this.firehoseClientProperties = firehoseClientProperties;
        return this;
    }

    @VisibleForTesting
    Properties getClientPropertiesWithDefaultHttpProtocol() {
        Properties clientProperties = Optional.ofNullable(this.firehoseClientProperties).orElse(new Properties());
        clientProperties.putIfAbsent("aws.http.protocol.version", DEFAULT_HTTP_PROTOCOL.toString());
        return clientProperties;
    }

    public KinesisFirehoseSink<InputT> build() {
        return new KinesisFirehoseSink(KinesisFirehoseSinkElementConverter.builder().setSerializationSchema(this.serializationSchema).build(), Optional.ofNullable(this.getMaxBatchSize()).orElse(500), Optional.ofNullable(this.getMaxInFlightRequests()).orElse(50), Optional.ofNullable(this.getMaxBufferedRequests()).orElse(10000), Optional.ofNullable(this.getMaxBatchSizeInBytes()).orElse(0x400000L), Optional.ofNullable(this.getMaxTimeInBufferMS()).orElse(5000L), Optional.ofNullable(this.getMaxRecordSizeInBytes()).orElse(1024000L), Optional.ofNullable(this.failOnError).orElse(false), this.deliveryStreamName, this.getClientPropertiesWithDefaultHttpProtocol());
    }
}

