/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.firehose.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseSinkBuilder;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseSinkWriter;
import org.apache.flink.connector.firehose.sink.KinesisFirehoseStateSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;
import software.amazon.awssdk.services.firehose.model.Record;

@PublicEvolving
public class KinesisFirehoseSink<InputT>
extends AsyncSinkBase<InputT, Record> {
    private final boolean failOnError;
    private final String deliveryStreamName;
    private final Properties firehoseClientProperties;

    KinesisFirehoseSink(ElementConverter<InputT, Record> elementConverter, Integer maxBatchSize, Integer maxInFlightRequests, Integer maxBufferedRequests, Long maxBatchSizeInBytes, Long maxTimeInBufferMS, Long maxRecordSizeInBytes, boolean failOnError, String deliveryStreamName, Properties firehoseClientProperties) {
        super(elementConverter, maxBatchSize.intValue(), maxInFlightRequests.intValue(), maxBufferedRequests.intValue(), maxBatchSizeInBytes.longValue(), maxTimeInBufferMS.longValue(), maxRecordSizeInBytes.longValue());
        this.deliveryStreamName = (String)Preconditions.checkNotNull((Object)deliveryStreamName, (String)"The delivery stream name must not be null when initializing the KDF Sink.");
        Preconditions.checkArgument((!this.deliveryStreamName.isEmpty() ? 1 : 0) != 0, (Object)"The delivery stream name must be set when initializing the KDF Sink.");
        this.failOnError = failOnError;
        this.firehoseClientProperties = firehoseClientProperties;
    }

    public static <InputT> KinesisFirehoseSinkBuilder<InputT> builder() {
        return new KinesisFirehoseSinkBuilder();
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<Record>> createWriter(Sink.InitContext context) throws IOException {
        return new KinesisFirehoseSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.deliveryStreamName, this.firehoseClientProperties, Collections.emptyList());
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<Record>> restoreWriter(Sink.InitContext context, Collection<BufferedRequestState<Record>> recoveredState) throws IOException {
        return new KinesisFirehoseSinkWriter(this.getElementConverter(), context, this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBatchSizeInBytes(), this.getMaxTimeInBufferMS(), this.getMaxRecordSizeInBytes(), this.failOnError, this.deliveryStreamName, this.firehoseClientProperties, recoveredState);
    }

    public SimpleVersionedSerializer<BufferedRequestState<Record>> getWriterStateSerializer() {
        return new KinesisFirehoseStateSerializer();
    }
}

