/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.util;

import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.runtime.util.EnvironmentInformation;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.utils.builder.SdkBuilder;

@Internal
public class AWSClientUtil
extends AWSGeneralUtil {
    static final String V2_USER_AGENT_SUFFIX = " V2";

    public static String formatFlinkUserAgentPrefix(String userAgentFormat) {
        return String.format(userAgentFormat, EnvironmentInformation.getVersion(), EnvironmentInformation.getRevisionInformation().commitId);
    }

    public static <S extends SdkClient, T extends AwsAsyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsAsyncClient(Properties configProps, SdkAsyncHttpClient httpClient, T clientBuilder, String awsUserAgentPrefixFormat, String awsClientUserAgentPrefix) {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().build();
        return AWSClientUtil.createAwsAsyncClient(configProps, clientConfiguration, httpClient, clientBuilder, awsUserAgentPrefixFormat, awsClientUserAgentPrefix);
    }

    public static <S extends SdkClient, T extends AwsAsyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsAsyncClient(Properties configProps, SdkClientConfiguration clientConfiguration, SdkAsyncHttpClient httpClient, T clientBuilder, String awsUserAgentPrefixFormat, String awsClientUserAgentPrefix) {
        String flinkUserAgentPrefix = AWSClientUtil.getFlinkUserAgentPrefix(configProps, awsUserAgentPrefixFormat, awsClientUserAgentPrefix);
        ClientOverrideConfiguration overrideConfiguration = AWSClientUtil.createClientOverrideConfiguration(clientConfiguration, ClientOverrideConfiguration.builder(), flinkUserAgentPrefix);
        return AWSClientUtil.createAwsAsyncClient(configProps, clientBuilder, httpClient, overrideConfiguration);
    }

    @VisibleForTesting
    static ClientOverrideConfiguration createClientOverrideConfiguration(SdkClientConfiguration config, ClientOverrideConfiguration.Builder overrideConfigurationBuilder, String flinkUserAgentPrefix) {
        overrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)flinkUserAgentPrefix).putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)((String)config.option((ClientOption)SdkAdvancedClientOption.USER_AGENT_SUFFIX)));
        Optional.ofNullable((Duration)config.option((ClientOption)SdkClientOption.API_CALL_ATTEMPT_TIMEOUT)).ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrideConfigurationBuilder).apiCallAttemptTimeout(arg_0));
        Optional.ofNullable((Duration)config.option((ClientOption)SdkClientOption.API_CALL_TIMEOUT)).ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrideConfigurationBuilder).apiCallTimeout(arg_0));
        return (ClientOverrideConfiguration)overrideConfigurationBuilder.build();
    }

    @VisibleForTesting
    static <S extends SdkClient, T extends AwsAsyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsAsyncClient(Properties configProps, T clientBuilder, SdkAsyncHttpClient httpClient, ClientOverrideConfiguration overrideConfiguration) {
        AWSClientUtil.updateEndpointOverride(configProps, clientBuilder);
        return (S)((SdkClient)((SdkBuilder)((AwsAsyncClientBuilder)((AwsClientBuilder)((AwsAsyncClientBuilder)((AwsClientBuilder)((AwsAsyncClientBuilder)((SdkClientBuilder)((AwsAsyncClientBuilder)clientBuilder.httpClient(httpClient))).overrideConfiguration(overrideConfiguration))).credentialsProvider(AWSClientUtil.getCredentialsProvider(configProps)))).region(AWSClientUtil.getRegion(configProps)))).build());
    }

    public static <S extends SdkClient, T extends AwsSyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsSyncClient(Properties configProps, SdkHttpClient httpClient, T clientBuilder, String awsUserAgentPrefixFormat, String awsClientUserAgentPrefix) {
        SdkClientConfiguration clientConfiguration = SdkClientConfiguration.builder().build();
        String flinkUserAgentPrefix = AWSClientUtil.getFlinkUserAgentPrefix(configProps, awsUserAgentPrefixFormat, awsClientUserAgentPrefix);
        ClientOverrideConfiguration overrideConfiguration = AWSClientUtil.createClientOverrideConfiguration(clientConfiguration, ClientOverrideConfiguration.builder(), flinkUserAgentPrefix);
        AWSClientUtil.updateEndpointOverride(configProps, clientBuilder);
        return (S)((SdkClient)((SdkBuilder)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsSyncClientBuilder)((SdkClientBuilder)((AwsSyncClientBuilder)clientBuilder.httpClient(httpClient))).overrideConfiguration(overrideConfiguration))).credentialsProvider(AWSClientUtil.getCredentialsProvider(configProps)))).region(AWSClientUtil.getRegion(configProps)))).build());
    }

    private static String getFlinkUserAgentPrefix(Properties configProps, String awsUserAgentPrefixFormat, String awsClientUserAgentPrefix) {
        return Optional.ofNullable(configProps.getProperty(awsClientUserAgentPrefix)).orElse(AWSClientUtil.formatFlinkUserAgentPrefix(awsUserAgentPrefixFormat + V2_USER_AGENT_SUFFIX));
    }

    private static <S extends SdkClient, T extends AwsClientBuilder<? extends T, S>> void updateEndpointOverride(Properties configProps, T clientBuilder) {
        if (configProps.containsKey("aws.endpoint")) {
            URI endpointOverride = URI.create(configProps.getProperty("aws.endpoint"));
            clientBuilder.endpointOverride(endpointOverride);
        }
    }
}

