/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.sink.throwable;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.sink.throwable.FatalExceptionClassifier;
import org.apache.flink.util.ExceptionUtils;
import software.amazon.awssdk.awscore.exception.AwsServiceException;

@Internal
public class AWSExceptionClassifierUtil {
    public static FatalExceptionClassifier withAWSServiceErrorCode(Class<? extends AwsServiceException> serviceExceptionType, String errorCode, Function<Throwable, Exception> mapper) {
        return new FatalExceptionClassifier(err -> {
            Optional exceptionOptional = ExceptionUtils.findThrowable((Throwable)err, (Class)serviceExceptionType);
            if (!exceptionOptional.isPresent()) {
                return false;
            }
            AwsServiceException exception = (AwsServiceException)exceptionOptional.get();
            return exception.awsErrorDetails() != null && Objects.equals(errorCode, exception.awsErrorDetails().errorCode());
        }, mapper);
    }
}

