/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.table.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.aws.table.util.AWSOptionUtils;
import org.apache.flink.connector.base.table.util.ConfigurationValidatorUtil;
import software.amazon.awssdk.http.Protocol;

@PublicEvolving
public class AsyncClientOptionsUtils
extends AWSOptionUtils {
    public static final String SINK_CLIENT_PREFIX = "sink.http-client.";
    private static final String CLIENT_MAX_CONCURRENCY_OPTION = "max-concurrency";
    private static final String CLIENT_MAX_TIMEOUT_OPTION = "read-timeout";
    private static final String CLIENT_HTTP_PROTOCOL_VERSION_OPTION = "protocol.version";
    private final Map<String, String> resolvedOptions;

    public AsyncClientOptionsUtils(Map<String, String> resolvedOptions) {
        super(resolvedOptions);
        this.resolvedOptions = resolvedOptions;
    }

    @Override
    public Map<String, String> getProcessedResolvedOptions() {
        Map<String, String> mappedResolvedOptions = super.getProcessedResolvedOptions();
        for (String key : this.resolvedOptions.keySet()) {
            if (!key.startsWith(SINK_CLIENT_PREFIX)) continue;
            mappedResolvedOptions.put(AsyncClientOptionsUtils.translateClientKeys(key), this.resolvedOptions.get(key));
        }
        return mappedResolvedOptions;
    }

    @Override
    public List<String> getNonValidatedPrefixes() {
        return Arrays.asList("aws.", SINK_CLIENT_PREFIX);
    }

    @Override
    public Properties getValidatedConfigurations() {
        Properties clientConfigurations = super.getValidatedConfigurations();
        clientConfigurations.putAll(this.getProcessedResolvedOptions());
        this.validatedConfigurations(clientConfigurations);
        return clientConfigurations;
    }

    private static String translateClientKeys(String key) {
        String truncatedKey;
        switch (truncatedKey = key.substring(SINK_CLIENT_PREFIX.length())) {
            case "max-concurrency": {
                return "aws.http-client.max-concurrency";
            }
            case "read-timeout": {
                return "aws.http-client.read-timeout";
            }
            case "protocol.version": {
                return "aws.http.protocol.version";
            }
        }
        return truncatedKey;
    }

    private void validatedConfigurations(Properties config) {
        ConfigurationValidatorUtil.validateOptionalPositiveIntProperty((Properties)config, (String)"aws.http-client.max-concurrency", (String)"Invalid value given for HTTP client max concurrency. Must be positive integer.");
        ConfigurationValidatorUtil.validateOptionalPositiveIntProperty((Properties)config, (String)"aws.http-client.read-timeout", (String)"Invalid value given for HTTP read timeout. Must be positive integer.");
        this.validateOptionalHttpProtocolProperty(config);
    }

    private void validateOptionalHttpProtocolProperty(Properties config) {
        if (config.containsKey("aws.http.protocol.version")) {
            try {
                Protocol.valueOf((String)config.getProperty("aws.http.protocol.version"));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid value given for HTTP protocol. Must be HTTP1_1 or HTTP2.");
            }
        }
    }
}

