/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.config;

import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class AWSConfigConstants {
    public static final String AWS_REGION = "aws.region";
    public static final String AWS_CREDENTIALS_PROVIDER = "aws.credentials.provider";
    public static final String AWS_ACCESS_KEY_ID = AWSConfigConstants.accessKeyId("aws.credentials.provider");
    public static final String AWS_SECRET_ACCESS_KEY = AWSConfigConstants.secretKey("aws.credentials.provider");
    public static final String AWS_PROFILE_PATH = AWSConfigConstants.profilePath("aws.credentials.provider");
    public static final String AWS_PROFILE_NAME = AWSConfigConstants.profileName("aws.credentials.provider");
    public static final String AWS_ROLE_STS_ENDPOINT = AWSConfigConstants.roleStsEndpoint("aws.credentials.provider");
    public static final String AWS_ROLE_ARN = AWSConfigConstants.roleArn("aws.credentials.provider");
    public static final String AWS_ROLE_SESSION_NAME = AWSConfigConstants.roleSessionName("aws.credentials.provider");
    public static final String AWS_ROLE_EXTERNAL_ID = AWSConfigConstants.externalId("aws.credentials.provider");
    public static final String AWS_WEB_IDENTITY_TOKEN_FILE = AWSConfigConstants.webIdentityTokenFile("aws.credentials.provider");
    public static final String AWS_ROLE_CREDENTIALS_PROVIDER = AWSConfigConstants.roleCredentialsProvider("aws.credentials.provider");
    public static final String AWS_ENDPOINT = "aws.endpoint";
    public static final String TRUST_ALL_CERTIFICATES = "aws.trust.all.certificates";
    public static final String HTTP_PROTOCOL_VERSION = "aws.http.protocol.version";
    public static final String HTTP_CLIENT_MAX_CONCURRENCY = "aws.http-client.max-concurrency";
    public static final String HTTP_CLIENT_READ_TIMEOUT_MILLIS = "aws.http-client.read-timeout";

    public static String accessKeyId(String prefix) {
        return prefix + ".basic.accesskeyid";
    }

    public static String secretKey(String prefix) {
        return prefix + ".basic.secretkey";
    }

    public static String profilePath(String prefix) {
        return prefix + ".profile.path";
    }

    public static String profileName(String prefix) {
        return prefix + ".profile.name";
    }

    public static String roleArn(String prefix) {
        return prefix + ".role.arn";
    }

    public static String roleSessionName(String prefix) {
        return prefix + ".role.sessionName";
    }

    public static String externalId(String prefix) {
        return prefix + ".role.externalId";
    }

    public static String roleCredentialsProvider(String prefix) {
        return prefix + ".role.provider";
    }

    public static String roleStsEndpoint(String prefix) {
        return prefix + ".role.stsEndpoint";
    }

    public static String webIdentityTokenFile(String prefix) {
        return prefix + ".webIdentityToken.file";
    }

    public static enum CredentialProvider {
        ENV_VAR,
        SYS_PROP,
        PROFILE,
        BASIC,
        ASSUME_ROLE,
        WEB_IDENTITY_TOKEN,
        AUTO;

    }
}

