/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.util;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.util.ExceptionUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.Http2Configuration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Internal
public class AWSGeneralUtil {
    private static final Duration CONNECTION_ACQUISITION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int INITIAL_WINDOW_SIZE_BYTES = 524288;
    private static final Duration HEALTH_CHECK_PING_PERIOD = Duration.ofSeconds(60L);
    private static final int HTTP_CLIENT_MAX_CONCURRENCY = 10000;
    private static final Duration HTTP_CLIENT_READ_TIMEOUT = Duration.ofMinutes(6L);
    private static final Protocol HTTP_PROTOCOL = Protocol.HTTP2;
    private static final boolean TRUST_ALL_CERTIFICATES = false;
    private static final AttributeMap HTTP_CLIENT_DEFAULTS = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)10000).put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)HTTP_CLIENT_READ_TIMEOUT).put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)false).put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, (Object)HTTP_PROTOCOL).build();

    public static AWSConfigConstants.CredentialProvider getCredentialProviderType(Properties configProps, String configPrefix) {
        if (!configProps.containsKey(configPrefix)) {
            if (configProps.containsKey(AWSConfigConstants.accessKeyId(configPrefix)) && configProps.containsKey(AWSConfigConstants.secretKey(configPrefix))) {
                return AWSConfigConstants.CredentialProvider.BASIC;
            }
            return AWSConfigConstants.CredentialProvider.AUTO;
        }
        try {
            return AWSConfigConstants.CredentialProvider.valueOf(configProps.getProperty(configPrefix));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid AWS Credential Provider Type %s.", configProps.getProperty(configPrefix)), e);
        }
    }

    public static AwsCredentialsProvider getCredentialsProvider(Map<String, ?> configProps) {
        Properties properties = new Properties();
        properties.putAll(configProps);
        return AWSGeneralUtil.getCredentialsProvider(properties);
    }

    public static AwsCredentialsProvider getCredentialsProvider(Properties configProps) {
        return AWSGeneralUtil.getCredentialsProvider(configProps, "aws.credentials.provider");
    }

    public static AwsCredentialsProvider getCredentialsProvider(Properties configProps, String configPrefix) {
        AWSConfigConstants.CredentialProvider credentialProviderType = AWSGeneralUtil.getCredentialProviderType(configProps, configPrefix);
        switch (credentialProviderType) {
            case ENV_VAR: {
                return EnvironmentVariableCredentialsProvider.create();
            }
            case SYS_PROP: {
                return SystemPropertyCredentialsProvider.create();
            }
            case PROFILE: {
                return AWSGeneralUtil.getProfileCredentialProvider(configProps, configPrefix);
            }
            case BASIC: {
                return () -> AwsBasicCredentials.create((String)configProps.getProperty(AWSConfigConstants.accessKeyId(configPrefix)), (String)configProps.getProperty(AWSConfigConstants.secretKey(configPrefix)));
            }
            case ASSUME_ROLE: {
                return AWSGeneralUtil.getAssumeRoleCredentialProvider(configProps, configPrefix);
            }
            case WEB_IDENTITY_TOKEN: {
                return AWSGeneralUtil.getWebIdentityTokenFileCredentialsProvider(WebIdentityTokenFileCredentialsProvider.builder(), configProps, configPrefix);
            }
            case AUTO: {
                return DefaultCredentialsProvider.create();
            }
        }
        throw new IllegalArgumentException("Credential provider not supported: " + (Object)((Object)credentialProviderType));
    }

    public static AwsCredentialsProvider getProfileCredentialProvider(Properties configProps, String configPrefix) {
        String profileName = configProps.getProperty(AWSConfigConstants.profileName(configPrefix), null);
        ProfileCredentialsProvider.Builder profileBuilder = ProfileCredentialsProvider.builder().profileName(profileName);
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.profilePath(configPrefix))).map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(path -> profileBuilder.profileFile(ProfileFile.builder().type(ProfileFile.Type.CREDENTIALS).content(path).build()));
        return profileBuilder.build();
    }

    private static AwsCredentialsProvider getAssumeRoleCredentialProvider(Properties configProps, String configPrefix) {
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix))).roleSessionName(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).externalId(configProps.getProperty(AWSConfigConstants.externalId(configPrefix))).build()).stsClient((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(AWSGeneralUtil.getCredentialsProvider(configProps, AWSConfigConstants.roleCredentialsProvider(configPrefix)))).region(AWSGeneralUtil.getRegion(configProps))).build())).build();
    }

    @VisibleForTesting
    static AwsCredentialsProvider getWebIdentityTokenFileCredentialsProvider(WebIdentityTokenFileCredentialsProvider.Builder webIdentityBuilder, Properties configProps, String configPrefix) {
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix))).ifPresent(arg_0 -> ((WebIdentityTokenFileCredentialsProvider.Builder)webIdentityBuilder).roleArn(arg_0));
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).ifPresent(arg_0 -> ((WebIdentityTokenFileCredentialsProvider.Builder)webIdentityBuilder).roleSessionName(arg_0));
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.webIdentityTokenFile(configPrefix))).map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(arg_0 -> ((WebIdentityTokenFileCredentialsProvider.Builder)webIdentityBuilder).webIdentityTokenFile(arg_0));
        return webIdentityBuilder.build();
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(Properties configProperties) {
        return AWSGeneralUtil.createAsyncHttpClient(configProperties, NettyNioAsyncHttpClient.builder());
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(Properties configProperties, NettyNioAsyncHttpClient.Builder httpClientBuilder) {
        AttributeMap.Builder clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TCP_KEEPALIVE, (Object)true);
        Optional.ofNullable(configProperties.getProperty("aws.http-client.max-concurrency")).map(Integer::parseInt).ifPresent(integer -> clientConfiguration.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, integer));
        Optional.ofNullable(configProperties.getProperty("aws.http-client.read-timeout")).map(Integer::parseInt).map(Duration::ofMillis).ifPresent(timeout -> clientConfiguration.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, timeout));
        Optional.ofNullable(configProperties.getProperty("aws.trust.all.certificates")).map(Boolean::parseBoolean).ifPresent(bool -> clientConfiguration.put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, bool));
        Optional.ofNullable(configProperties.getProperty("aws.http.protocol.version")).map(Protocol::valueOf).ifPresent(protocol -> clientConfiguration.put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, protocol));
        return AWSGeneralUtil.createAsyncHttpClient(clientConfiguration.build(), httpClientBuilder);
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(NettyNioAsyncHttpClient.Builder httpClientBuilder) {
        return AWSGeneralUtil.createAsyncHttpClient(AttributeMap.empty(), httpClientBuilder);
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(AttributeMap config, NettyNioAsyncHttpClient.Builder httpClientBuilder) {
        httpClientBuilder.connectionAcquisitionTimeout(CONNECTION_ACQUISITION_TIMEOUT).http2Configuration((Http2Configuration)Http2Configuration.builder().healthCheckPingPeriod(HEALTH_CHECK_PING_PERIOD).initialWindowSize(Integer.valueOf(524288)).build());
        return httpClientBuilder.buildWithDefaults(config.merge(HTTP_CLIENT_DEFAULTS));
    }

    public static Region getRegion(Properties configProps) {
        return Region.of((String)configProps.getProperty("aws.region"));
    }

    public static boolean isValidRegion(Region region) {
        return Pattern.matches("^[a-z]+-([a-z]+[-]{0,1}[a-z]+-([0-9]|global)|global)$", region.id());
    }

    public static void validateAwsConfiguration(Properties config) {
        if (config.containsKey("aws.credentials.provider")) {
            AWSGeneralUtil.validateCredentialProvider(config);
            AWSConfigConstants.CredentialProvider credentialsProviderType = AWSGeneralUtil.getCredentialProviderType(config, "aws.credentials.provider");
            if (!(credentialsProviderType != AWSConfigConstants.CredentialProvider.BASIC || config.containsKey(AWSConfigConstants.AWS_ACCESS_KEY_ID) && config.containsKey(AWSConfigConstants.AWS_SECRET_ACCESS_KEY))) {
                throw new IllegalArgumentException("Please set values for AWS Access Key ID ('" + AWSConfigConstants.AWS_ACCESS_KEY_ID + "') and Secret Key ('" + AWSConfigConstants.AWS_SECRET_ACCESS_KEY + "') when using the BASIC AWS credential provider type.");
            }
        }
        if (config.containsKey("aws.region") && !AWSGeneralUtil.isValidRegion(AWSGeneralUtil.getRegion(config))) {
            StringBuilder sb = new StringBuilder();
            for (Region region : Region.regions()) {
                sb.append(region).append(", ");
            }
            throw new IllegalArgumentException("Invalid AWS region set in config. Valid values are: " + sb.toString());
        }
    }

    public static void closeResources(SdkAutoCloseable ... resources) {
        RuntimeException exception = null;
        for (SdkAutoCloseable resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (RuntimeException e) {
                exception = (RuntimeException)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void validateAwsCredentials(Properties config) {
        AWSGeneralUtil.validateAwsConfiguration(config);
        AWSGeneralUtil.getCredentialsProvider(config).resolveCredentials();
    }

    private static void validateCredentialProvider(Properties config) {
        try {
            AWSGeneralUtil.getCredentialsProvider(config);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            for (AWSConfigConstants.CredentialProvider type : AWSConfigConstants.CredentialProvider.values()) {
                sb.append(type.toString()).append(", ");
            }
            throw new IllegalArgumentException("Invalid AWS Credential Provider Type set in config. Valid values are: " + sb.toString());
        }
    }
}

