/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.util;

import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;

public class TestUtil {
    public static Properties properties(String key, String value) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        return properties;
    }

    public static Properties getStandardProperties() {
        Properties config = TestUtil.properties("aws.region", "us-east-1");
        config.setProperty(AWSConfigConstants.AWS_ACCESS_KEY_ID, "accessKeyId");
        config.setProperty(AWSConfigConstants.AWS_SECRET_ACCESS_KEY, "secretKey");
        return config;
    }

    public static NettyConfiguration getNettyConfiguration(SdkAsyncHttpClient httpClient) throws Exception {
        return (NettyConfiguration)TestUtil.getField("configuration", httpClient);
    }

    public static <T> T getField(String fieldName, Object obj) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }
}

