/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.testutils;

import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.waiters.S3Waiter;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public class AWSServicesTestUtils {
    private static final String ACCESS_KEY_ID = "accessKeyId";
    private static final String SECRET_ACCESS_KEY = "secretAccessKey";

    public static S3Client createS3Client(String endpoint, SdkHttpClient httpClient) {
        return (S3Client)AWSServicesTestUtils.createAwsSyncClient(endpoint, httpClient, S3Client.builder());
    }

    public static IamClient createIamClient(String endpoint, SdkHttpClient httpClient) {
        return (IamClient)AWSServicesTestUtils.createAwsSyncClient(endpoint, httpClient, IamClient.builder());
    }

    public static <S extends SdkClient, T extends AwsSyncClientBuilder<? extends T, S> & AwsClientBuilder<? extends T, S>> S createAwsSyncClient(String endpoint, SdkHttpClient httpClient, T clientBuilder) {
        Properties config = AWSServicesTestUtils.createConfig(endpoint);
        return (S)((SdkClient)((SdkBuilder)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsSyncClientBuilder)((SdkClientBuilder)((AwsSyncClientBuilder)clientBuilder.httpClient(httpClient))).endpointOverride(URI.create(endpoint)))).credentialsProvider(AWSGeneralUtil.getCredentialsProvider((Properties)config)))).region(AWSGeneralUtil.getRegion((Properties)config)))).build());
    }

    public static Properties createConfig(String endpoint) {
        Properties config = new Properties();
        config.setProperty("aws.region", Region.AP_SOUTHEAST_1.toString());
        config.setProperty("aws.endpoint", endpoint);
        config.setProperty(AWSConfigConstants.accessKeyId((String)"aws.credentials.provider"), ACCESS_KEY_ID);
        config.setProperty(AWSConfigConstants.secretKey((String)"aws.credentials.provider"), SECRET_ACCESS_KEY);
        config.setProperty("aws.trust.all.certificates", "true");
        return config;
    }

    public static SdkHttpClient createHttpClient() {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)true);
        attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, (Object)Protocol.HTTP1_1);
        return ApacheHttpClient.builder().buildWithDefaults(attributeMapBuilder.build());
    }

    public static void createBucket(S3Client s3Client, String bucketName) {
        CreateBucketRequest bucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
        s3Client.createBucket(bucketRequest);
        HeadBucketRequest bucketRequestWait = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build();
        try (S3Waiter waiter = s3Client.waiter();){
            waiter.waitUntilBucketExists(bucketRequestWait);
        }
    }

    public static void createIAMRole(IamClient iam, String roleName) {
        CreateRoleRequest request = (CreateRoleRequest)CreateRoleRequest.builder().roleName(roleName).build();
        iam.createRole(request);
    }

    public static List<S3Object> listBucketObjects(S3Client s3, String bucketName) {
        ListObjectsV2Request listObjects = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).build();
        ListObjectsV2Response res = s3.listObjectsV2(listObjects);
        return res.contents();
    }

    public static <T> List<T> readObjectsFromS3Bucket(S3Client s3Client, List<S3Object> objects, String bucketName, Function<ResponseBytes<GetObjectResponse>, T> deserializer) {
        return objects.stream().map(object -> (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(object.key()).build()).map(arg_0 -> ((S3Client)s3Client).getObjectAsBytes(arg_0)).map(deserializer).collect(Collectors.toList());
    }
}

