/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.connector.aws.util.TestUtil;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.ImmutableMap;

public class AWSGeneralUtilTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testGetCredentialsProviderTypeDefaultsAuto() {
        Assert.assertEquals((Object)AWSConfigConstants.CredentialProvider.AUTO, (Object)AWSGeneralUtil.getCredentialProviderType((Properties)new Properties(), (String)"aws.credentials.provider"));
    }

    @Test
    public void testGetCredentialsProviderTypeBasic() {
        Properties testConfig = TestUtil.properties(AWSConfigConstants.accessKeyId((String)"aws.credentials.provider"), "ak");
        testConfig.setProperty(AWSConfigConstants.secretKey((String)"aws.credentials.provider"), "sk");
        Assert.assertEquals((Object)AWSConfigConstants.CredentialProvider.BASIC, (Object)AWSGeneralUtil.getCredentialProviderType((Properties)testConfig, (String)"aws.credentials.provider"));
    }

    @Test
    public void testGetCredentialsProviderTypeWebIdentityToken() {
        Properties testConfig = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        AWSConfigConstants.CredentialProvider type = AWSGeneralUtil.getCredentialProviderType((Properties)testConfig, (String)"aws.credentials.provider");
        Assert.assertEquals((Object)AWSConfigConstants.CredentialProvider.WEB_IDENTITY_TOKEN, (Object)type);
    }

    @Test
    public void testGetCredentialsProviderTypeAssumeRole() {
        Properties testConfig = TestUtil.properties("aws.credentials.provider", "ASSUME_ROLE");
        AWSConfigConstants.CredentialProvider type = AWSGeneralUtil.getCredentialProviderType((Properties)testConfig, (String)"aws.credentials.provider");
        Assert.assertEquals((Object)AWSConfigConstants.CredentialProvider.ASSUME_ROLE, (Object)type);
    }

    @Test
    public void testGetCredentialsProviderEnvironmentVariables() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "ENV_VAR");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof EnvironmentVariableCredentialsProvider));
    }

    @Test
    public void testGetCredentialsProviderSystemProperties() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "SYS_PROP");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof SystemPropertyCredentialsProvider));
    }

    @Test
    public void testGetCredentialsProviderWebIdentityTokenFileCredentialsProvider() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof WebIdentityTokenFileCredentialsProvider));
    }

    @Test
    public void testGetWebIdentityTokenFileCredentialsProvider() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        properties.setProperty(AWSConfigConstants.roleArn((String)"aws.credentials.provider"), "roleArn");
        properties.setProperty(AWSConfigConstants.roleSessionName((String)"aws.credentials.provider"), "roleSessionName");
        WebIdentityTokenFileCredentialsProvider.Builder builder = this.mockWebIdentityTokenFileCredentialsProviderBuilder();
        AWSGeneralUtil.getWebIdentityTokenFileCredentialsProvider((WebIdentityTokenFileCredentialsProvider.Builder)builder, (Properties)properties, (String)"aws.credentials.provider");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder)).roleArn("roleArn");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder)).roleSessionName("roleSessionName");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder, (VerificationMode)Mockito.never())).webIdentityTokenFile((Path)ArgumentMatchers.any());
    }

    @Test
    public void testGetWebIdentityTokenFileCredentialsProviderWithWebIdentityFile() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        properties.setProperty(AWSConfigConstants.webIdentityTokenFile((String)"aws.credentials.provider"), "webIdentityTokenFile");
        WebIdentityTokenFileCredentialsProvider.Builder builder = this.mockWebIdentityTokenFileCredentialsProviderBuilder();
        AWSGeneralUtil.getWebIdentityTokenFileCredentialsProvider((WebIdentityTokenFileCredentialsProvider.Builder)builder, (Properties)properties, (String)"aws.credentials.provider");
        ((WebIdentityTokenFileCredentialsProvider.Builder)Mockito.verify((Object)builder)).webIdentityTokenFile(Paths.get("webIdentityTokenFile", new String[0]));
    }

    @Test
    public void testGetCredentialsProviderAuto() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "AUTO");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof DefaultCredentialsProvider));
    }

    @Test
    public void testGetCredentialsProviderFromMap() {
        ImmutableMap config = ImmutableMap.of((Object)"aws.credentials.provider", (Object)"AUTO");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Map)config);
        Assert.assertTrue((boolean)(credentialsProvider instanceof DefaultCredentialsProvider));
    }

    @Test
    public void testGetCredentialsProviderAssumeRole() {
        Properties properties = (Properties)Mockito.spy((Object)TestUtil.properties("aws.credentials.provider", "ASSUME_ROLE"));
        properties.setProperty("aws.region", "eu-west-2");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof StsAssumeRoleCredentialsProvider));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.roleArn((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.roleSessionName((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty(AWSConfigConstants.externalId((String)"aws.credentials.provider"));
        ((Properties)Mockito.verify((Object)properties)).getProperty("aws.region");
    }

    @Test
    public void testGetCredentialsProviderBasic() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "BASIC");
        properties.setProperty(AWSConfigConstants.accessKeyId((String)"aws.credentials.provider"), "ak");
        properties.setProperty(AWSConfigConstants.secretKey((String)"aws.credentials.provider"), "sk");
        AwsCredentials credentials = AWSGeneralUtil.getCredentialsProvider((Properties)properties).resolveCredentials();
        Assert.assertEquals((Object)"ak", (Object)credentials.accessKeyId());
        Assert.assertEquals((Object)"sk", (Object)credentials.secretAccessKey());
    }

    @Test
    public void testGetCredentialsProviderProfile() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "PROFILE");
        properties.put(AWSConfigConstants.profileName((String)"aws.credentials.provider"), "default");
        properties.put(AWSConfigConstants.profilePath((String)"aws.credentials.provider"), "src/test/resources/profile");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof ProfileCredentialsProvider));
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Assert.assertEquals((Object)"11111111111111111111", (Object)credentials.accessKeyId());
        Assert.assertEquals((Object)"wJalrXUtnFEMI/K7MDENG/bPxRfiCY1111111111", (Object)credentials.secretAccessKey());
    }

    @Test
    public void testGetCredentialsProviderNamedProfile() {
        Properties properties = TestUtil.properties("aws.credentials.provider", "PROFILE");
        properties.setProperty(AWSConfigConstants.profileName((String)"aws.credentials.provider"), "foo");
        properties.setProperty(AWSConfigConstants.profilePath((String)"aws.credentials.provider"), "src/test/resources/profile");
        AwsCredentialsProvider credentialsProvider = AWSGeneralUtil.getCredentialsProvider((Properties)properties);
        Assert.assertTrue((boolean)(credentialsProvider instanceof ProfileCredentialsProvider));
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Assert.assertEquals((Object)"22222222222222222222", (Object)credentials.accessKeyId());
        Assert.assertEquals((Object)"wJalrXUtnFEMI/K7MDENG/bPxRfiCY2222222222", (Object)credentials.secretAccessKey());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithPropertyTcpKeepAlive() throws Exception {
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)new Properties());
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertTrue((boolean)nettyConfiguration.tcpKeepAlive());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithPropertyMaxConcurrency() throws Exception {
        int maxConnections = 45678;
        Properties properties = new Properties();
        properties.setProperty("aws.http-client.max-concurrency", String.valueOf(maxConnections));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)maxConnections, (long)nettyConfiguration.maxConnections());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithPropertyReadTimeout() throws Exception {
        int readTimeoutMillis = 45678;
        Properties properties = new Properties();
        properties.setProperty("aws.http-client.read-timeout", String.valueOf(readTimeoutMillis));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)readTimeoutMillis, (long)nettyConfiguration.readTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithPropertyTrustAllCertificates() throws Exception {
        boolean trustAllCerts = true;
        Properties properties = new Properties();
        properties.setProperty("aws.trust.all.certificates", String.valueOf(trustAllCerts));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)trustAllCerts, (Object)nettyConfiguration.trustAllCertificates());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithPropertyProtocol() throws Exception {
        Protocol httpVersion = Protocol.HTTP1_1;
        Properties properties = new Properties();
        properties.setProperty("aws.http.protocol.version", String.valueOf(httpVersion));
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((Properties)properties);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)httpVersion, (Object)nettyConfiguration.attribute((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL));
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsConnectionAcquireTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)60000L, (long)nettyConfiguration.connectionAcquireTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsConnectionTtl() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((long)nettyDefaultConfiguration.connectionTtlMillis(), (long)nettyConfiguration.connectionTtlMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsConnectionTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((long)nettyDefaultConfiguration.connectTimeoutMillis(), (long)nettyConfiguration.connectTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsIdleTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((long)nettyDefaultConfiguration.idleTimeoutMillis(), (long)nettyConfiguration.idleTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsMaxConnections() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)10000L, (long)nettyConfiguration.maxConnections());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsMaxPendingConnectionAcquires() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((long)nettyDefaultConfiguration.maxPendingConnectionAcquires(), (long)nettyConfiguration.maxPendingConnectionAcquires());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsReadTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)360000L, (long)nettyConfiguration.readTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsReapIdleConnections() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((Object)nettyDefaultConfiguration.reapIdleConnections(), (Object)nettyConfiguration.reapIdleConnections());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsTcpKeepAlive() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((Object)nettyDefaultConfiguration.tcpKeepAlive(), (Object)nettyConfiguration.tcpKeepAlive());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsTlsKeyManagersProvider() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((Object)nettyDefaultConfiguration.tlsKeyManagersProvider(), (Object)nettyConfiguration.tlsKeyManagersProvider());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsTlsTrustManagersProvider() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((Object)nettyDefaultConfiguration.tlsTrustManagersProvider(), (Object)nettyConfiguration.tlsTrustManagersProvider());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsTrustAllCertificates() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)false, (Object)nettyConfiguration.trustAllCertificates());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsWriteTimeout() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        SdkAsyncHttpClient httpDefaultClient = NettyNioAsyncHttpClient.create();
        NettyConfiguration nettyDefaultConfiguration = TestUtil.getNettyConfiguration(httpDefaultClient);
        Assert.assertEquals((long)nettyDefaultConfiguration.writeTimeoutMillis(), (long)nettyConfiguration.writeTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWithDefaultsProtocol() throws Exception {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)Protocol.HTTP2, (Object)nettyConfiguration.attribute((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL));
    }

    @Test
    public void testCreateNettyAsyncHttpClientReadTimeout() throws Exception {
        Duration readTimeout = Duration.ofMillis(1234L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)readTimeout).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)readTimeout.toMillis(), (long)nettyConfiguration.readTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientTcpKeepAlive() throws Exception {
        boolean tcpKeepAlive = true;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TCP_KEEPALIVE, (Object)tcpKeepAlive).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)tcpKeepAlive, (Object)nettyConfiguration.tcpKeepAlive());
    }

    @Test
    public void testCreateNettyAsyncHttpClientConnectionTimeout() throws Exception {
        Duration connectionTimeout = Duration.ofMillis(1000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)connectionTimeout.toMillis(), (long)nettyConfiguration.connectTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientMaxConcurrency() throws Exception {
        int maxConnections = 123;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnections).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)maxConnections, (long)nettyConfiguration.maxConnections());
    }

    @Test
    public void testCreateNettyAsyncHttpClientWriteTimeout() throws Exception {
        Duration writeTimeout = Duration.ofMillis(3000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.WRITE_TIMEOUT, (Object)writeTimeout).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)writeTimeout.toMillis(), (long)nettyConfiguration.writeTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientConnectionMaxIdleTime() throws Exception {
        Duration maxIdleTime = Duration.ofMillis(2000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)maxIdleTime).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)maxIdleTime.toMillis(), (long)nettyConfiguration.idleTimeoutMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientIdleConnectionReaper() throws Exception {
        boolean reapIdleConnections = false;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS, (Object)reapIdleConnections).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)reapIdleConnections, (Object)nettyConfiguration.reapIdleConnections());
    }

    @Test
    public void testCreateNettyAsyncHttpClientIdleConnectionTtl() throws Exception {
        Duration connectionTtl = Duration.ofMillis(5000L);
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)connectionTtl).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((long)connectionTtl.toMillis(), (long)nettyConfiguration.connectionTtlMillis());
    }

    @Test
    public void testCreateNettyAsyncHttpClientTrustAllCertificates() throws Exception {
        boolean trustAllCertificates = true;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)trustAllCertificates).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)trustAllCertificates, (Object)nettyConfiguration.trustAllCertificates());
    }

    @Test
    public void testCreateNettyAsyncHttpClientHttpVersion() throws Exception {
        Protocol httpVersion = Protocol.HTTP1_1;
        AttributeMap clientConfiguration = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, (Object)httpVersion).build();
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        SdkAsyncHttpClient httpClient = AWSGeneralUtil.createAsyncHttpClient((AttributeMap)clientConfiguration, (NettyNioAsyncHttpClient.Builder)builder);
        NettyConfiguration nettyConfiguration = TestUtil.getNettyConfiguration(httpClient);
        Assert.assertEquals((Object)httpVersion, (Object)nettyConfiguration.attribute((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL));
    }

    @Test
    public void testGetRegion() {
        Region region = AWSGeneralUtil.getRegion((Properties)TestUtil.properties("aws.region", "eu-west-2"));
        Assert.assertEquals((Object)Region.EU_WEST_2, (Object)region);
    }

    @Test
    public void testValidRegion() {
        Assert.assertTrue((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"us-east-1")));
        Assert.assertTrue((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"us-gov-west-1")));
        Assert.assertTrue((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"us-isob-east-1")));
        Assert.assertTrue((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"aws-global")));
        Assert.assertTrue((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"aws-iso-global")));
        Assert.assertTrue((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"aws-iso-b-global")));
    }

    @Test
    public void testInvalidRegion() {
        Assertions.assertThat((boolean)AWSGeneralUtil.isValidRegion((Region)Region.of((String)"unstructured-string"))).isFalse();
    }

    @Test
    public void testUnrecognizableAwsRegionInConfig() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Invalid AWS region");
        Properties testConfig = TestUtil.properties("aws.region", "wrongRegionId");
        testConfig.setProperty(AWSConfigConstants.AWS_ACCESS_KEY_ID, "accessKeyId");
        testConfig.setProperty(AWSConfigConstants.AWS_SECRET_ACCESS_KEY, "secretKey");
        AWSGeneralUtil.validateAwsConfiguration((Properties)testConfig);
    }

    @Test
    public void testCredentialProviderTypeSetToBasicButNoCredentialSetInConfig() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Please set values for AWS Access Key ID ('" + AWSConfigConstants.AWS_ACCESS_KEY_ID + "') and Secret Key ('" + AWSConfigConstants.AWS_SECRET_ACCESS_KEY + "') when using the BASIC AWS credential provider type.");
        Properties testConfig = TestUtil.properties("aws.region", "us-east-1");
        testConfig.setProperty("aws.credentials.provider", "BASIC");
        AWSGeneralUtil.validateAwsConfiguration((Properties)testConfig);
    }

    @Test
    public void testUnrecognizableCredentialProviderTypeInConfig() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Invalid AWS Credential Provider Type");
        Properties testConfig = TestUtil.getStandardProperties();
        testConfig.setProperty("aws.credentials.provider", "wrongProviderType");
        AWSGeneralUtil.validateAwsConfiguration((Properties)testConfig);
    }

    @Test
    public void testMissingWebIdentityTokenFileInCredentials() {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Either the environment variable AWS_WEB_IDENTITY_TOKEN_FILE or the javaproperty aws.webIdentityTokenFile must be set");
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "WEB_IDENTITY_TOKEN");
        AWSGeneralUtil.validateAwsCredentials((Properties)properties);
    }

    @Test
    public void testMissingEnvironmentVariableCredentials() {
        this.exception.expect(SdkClientException.class);
        this.exception.expectMessage("Access key must be specified either via environment variable");
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "ENV_VAR");
        AWSGeneralUtil.validateAwsCredentials((Properties)properties);
    }

    @Test
    public void testFailedSystemPropertiesCredentialsValidationsOnMissingAccessKey() {
        this.exception.expect(SdkClientException.class);
        this.exception.expectMessage("Access key must be specified either via environment variable (AWS_ACCESS_KEY_ID) or system property (aws.accessKeyId)");
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "SYS_PROP");
        AWSGeneralUtil.validateAwsCredentials((Properties)properties);
    }

    @Test
    public void testFailedSystemPropertiesCredentialsValidationsOnMissingSecretKey() {
        System.setProperty("aws.accessKeyId", "accesKeyId");
        this.exception.expect(SdkClientException.class);
        this.exception.expectMessage("Secret key must be specified either via environment variable (AWS_SECRET_ACCESS_KEY) or system property (aws.secretAccessKey)");
        Properties properties = TestUtil.getStandardProperties();
        properties.setProperty("aws.credentials.provider", "SYS_PROP");
        AWSGeneralUtil.validateAwsCredentials((Properties)properties);
    }

    private WebIdentityTokenFileCredentialsProvider.Builder mockWebIdentityTokenFileCredentialsProviderBuilder() {
        WebIdentityTokenFileCredentialsProvider.Builder builder = (WebIdentityTokenFileCredentialsProvider.Builder)Mockito.mock(WebIdentityTokenFileCredentialsProvider.Builder.class);
        Mockito.when((Object)builder.roleArn((String)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.roleSessionName((String)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.webIdentityTokenFile((Path)ArgumentMatchers.any())).thenReturn((Object)builder);
        return builder;
    }
}

