/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.testutils;

import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.connector.aws.util.AWSGeneralUtil;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamAsyncClientBuilder;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.waiters.S3AsyncWaiter;

public class AWSServicesTestUtils {
    private static final String ACCESS_KEY_ID = "accessKeyId";
    private static final String SECRET_ACCESS_KEY = "secretAccessKey";

    public static S3AsyncClient createS3Client(String endpoint, SdkAsyncHttpClient httpClient) {
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().httpClient(httpClient)).region(Region.AP_SOUTHEAST_1)).endpointOverride(URI.create(endpoint))).credentialsProvider(AWSServicesTestUtils.createDefaultCredentials())).build();
    }

    public static IamAsyncClient createIamClient(String endpoint, SdkAsyncHttpClient httpClient) {
        return (IamAsyncClient)((IamAsyncClientBuilder)((IamAsyncClientBuilder)((IamAsyncClientBuilder)((IamAsyncClientBuilder)IamAsyncClient.builder().httpClient(httpClient)).region(Region.AWS_GLOBAL)).endpointOverride(URI.create(endpoint))).credentialsProvider(AWSServicesTestUtils.createDefaultCredentials())).build();
    }

    public static AwsCredentialsProvider createDefaultCredentials() {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)ACCESS_KEY_ID, (String)SECRET_ACCESS_KEY));
    }

    public static Properties createConfig(String endpoint) {
        Properties config = new Properties();
        config.setProperty("aws.region", Region.AP_SOUTHEAST_1.toString());
        config.setProperty("aws.endpoint", endpoint);
        config.setProperty(AWSConfigConstants.accessKeyId((String)"aws.credentials.provider"), ACCESS_KEY_ID);
        config.setProperty(AWSConfigConstants.secretKey((String)"aws.credentials.provider"), SECRET_ACCESS_KEY);
        config.setProperty("aws.trust.all.certificates", "true");
        return config;
    }

    public static SdkAsyncHttpClient createHttpClient(String endpoint) {
        return AWSGeneralUtil.createAsyncHttpClient((Properties)AWSServicesTestUtils.createConfig(endpoint), (NettyNioAsyncHttpClient.Builder)NettyNioAsyncHttpClient.builder().eventLoopGroupBuilder(SdkEventLoopGroup.builder()));
    }

    public static void createBucket(S3AsyncClient s3Client, String bucketName) throws ExecutionException, InterruptedException {
        CreateBucketRequest bucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
        s3Client.createBucket(bucketRequest);
        HeadBucketRequest bucketRequestWait = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build();
        try (S3AsyncWaiter waiter = s3Client.waiter();){
            waiter.waitUntilBucketExists(bucketRequestWait).get();
        }
    }

    public static void createIAMRole(IamAsyncClient iam, String roleName) throws ExecutionException, InterruptedException {
        CreateRoleRequest request = (CreateRoleRequest)CreateRoleRequest.builder().roleName(roleName).build();
        CompletableFuture responseFuture = iam.createRole(request);
        responseFuture.get();
    }

    public static List<S3Object> listBucketObjects(S3AsyncClient s3, String bucketName) throws ExecutionException, InterruptedException {
        ListObjectsRequest listObjects = (ListObjectsRequest)ListObjectsRequest.builder().bucket(bucketName).build();
        CompletableFuture res = s3.listObjects(listObjects);
        return ((ListObjectsResponse)res.get()).contents();
    }

    public static <T> List<T> readObjectsFromS3Bucket(S3AsyncClient s3AsyncClient, List<S3Object> objects, String bucketName, Function<ResponseBytes<GetObjectResponse>, T> deserializer) {
        S3BucketReader bucketReader = new S3BucketReader(s3AsyncClient, bucketName);
        return bucketReader.readObjects(objects, deserializer);
    }

    private static class S3BucketReader {
        private final S3AsyncClient s3AsyncClient;
        private final String bucketName;

        public S3BucketReader(S3AsyncClient s3AsyncClient, String bucketName) {
            this.s3AsyncClient = s3AsyncClient;
            this.bucketName = bucketName;
        }

        public <T> List<T> readObjects(List<S3Object> objectList, Function<ResponseBytes<GetObjectResponse>, T> deserializer) {
            return objectList.stream().map(object -> this.readObjectWitKey(object.key(), deserializer)).collect(Collectors.toList());
        }

        public <T> T readObjectWitKey(String key, Function<ResponseBytes<GetObjectResponse>, T> deserializer) {
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(key).build();
            return ((CompletableFuture)this.s3AsyncClient.getObject(getObjectRequest, AsyncResponseTransformer.toBytes()).thenApply(deserializer)).join();
        }
    }
}

