/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.table.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.connector.aws.table.util.AsyncClientOptionsUtils;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class AsyncClientOptionsUtilsTest
extends TestLogger {
    @Test
    public void testGoodAsyncClientOptionsMapping() {
        AsyncClientOptionsUtils asyncClientOptionsUtils = new AsyncClientOptionsUtils(AsyncClientOptionsUtilsTest.getDefaultClientOptions());
        Map<String, String> expectedConfigurations = AsyncClientOptionsUtilsTest.getDefaultExpectedClientOptions();
        Map actualConfigurations = asyncClientOptionsUtils.getProcessedResolvedOptions();
        Assertions.assertThat((Map)actualConfigurations).isEqualTo(expectedConfigurations);
    }

    @Test
    public void testAsyncClientOptionsUtilsFilteringNonPrefixedOptions() {
        Map<String, String> defaultClientOptions = AsyncClientOptionsUtilsTest.getDefaultClientOptions();
        defaultClientOptions.put("sink.not.http-client.some.option", "someValue");
        AsyncClientOptionsUtils asyncClientOptionsUtils = new AsyncClientOptionsUtils(defaultClientOptions);
        Map<String, String> expectedConfigurations = AsyncClientOptionsUtilsTest.getDefaultExpectedClientOptions();
        Map actualConfigurations = asyncClientOptionsUtils.getProcessedResolvedOptions();
        Assertions.assertThat((Map)actualConfigurations).isEqualTo(expectedConfigurations);
    }

    @Test
    public void testAsyncClientOptionsUtilsExtractingCorrectConfiguration() {
        AsyncClientOptionsUtils asyncClientOptionsUtils = new AsyncClientOptionsUtils(AsyncClientOptionsUtilsTest.getDefaultClientOptions());
        Properties expectedConfigurations = AsyncClientOptionsUtilsTest.getDefaultExpectedClientConfigs();
        Properties actualConfigurations = asyncClientOptionsUtils.getValidatedConfigurations();
        Assertions.assertThat((Map)actualConfigurations).isEqualTo((Object)expectedConfigurations);
    }

    @Test
    public void testAsyncClientOptionsUtilsFailOnInvalidMaxConcurrency() {
        Map<String, String> defaultClientOptions = AsyncClientOptionsUtilsTest.getDefaultClientOptions();
        defaultClientOptions.put("sink.http-client.max-concurrency", "invalid-integer");
        AsyncClientOptionsUtils asyncClientOptionsUtils = new AsyncClientOptionsUtils(defaultClientOptions);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((AsyncClientOptionsUtils)asyncClientOptionsUtils).getValidatedConfigurations()).withMessageContaining("Invalid value given for HTTP client max concurrency. Must be positive integer.");
    }

    @Test
    public void testAsyncClientOptionsUtilsFailOnInvalidReadTimeout() {
        Map<String, String> defaultClientOptions = AsyncClientOptionsUtilsTest.getDefaultClientOptions();
        defaultClientOptions.put("sink.http-client.read-timeout", "invalid-integer");
        AsyncClientOptionsUtils asyncClientOptionsUtils = new AsyncClientOptionsUtils(defaultClientOptions);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((AsyncClientOptionsUtils)asyncClientOptionsUtils).getValidatedConfigurations()).withMessageContaining("Invalid value given for HTTP read timeout. Must be positive integer.");
    }

    @Test
    public void testAsyncClientOptionsUtilsFailOnInvalidHttpProtocol() {
        Map<String, String> defaultProperties = AsyncClientOptionsUtilsTest.getDefaultClientOptions();
        defaultProperties.put("sink.http-client.protocol.version", "invalid-http-protocol");
        AsyncClientOptionsUtils asyncClientOptionsUtils = new AsyncClientOptionsUtils(defaultProperties);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ((AsyncClientOptionsUtils)asyncClientOptionsUtils).getValidatedConfigurations()).withMessageContaining("Invalid value given for HTTP protocol. Must be HTTP1_1 or HTTP2.");
    }

    private static Map<String, String> getDefaultClientOptions() {
        HashMap<String, String> defaultKinesisClientOptions = new HashMap<String, String>();
        defaultKinesisClientOptions.put("aws.region", "us-east-1");
        defaultKinesisClientOptions.put("sink.http-client.max-concurrency", "10000");
        defaultKinesisClientOptions.put("sink.http-client.read-timeout", "360000");
        defaultKinesisClientOptions.put("sink.http-client.protocol.version", "HTTP2");
        return defaultKinesisClientOptions;
    }

    private static Map<String, String> getDefaultExpectedClientOptions() {
        HashMap<String, String> defaultExpectedKinesisClientConfigurations = new HashMap<String, String>();
        defaultExpectedKinesisClientConfigurations.put("aws.region", "us-east-1");
        defaultExpectedKinesisClientConfigurations.put("aws.http-client.max-concurrency", "10000");
        defaultExpectedKinesisClientConfigurations.put("aws.http-client.read-timeout", "360000");
        defaultExpectedKinesisClientConfigurations.put("aws.http.protocol.version", "HTTP2");
        return defaultExpectedKinesisClientConfigurations;
    }

    private static Properties getDefaultExpectedClientConfigs() {
        Properties defaultExpectedKinesisClientConfigurations = new Properties();
        defaultExpectedKinesisClientConfigurations.put("aws.region", "us-east-1");
        defaultExpectedKinesisClientConfigurations.put("aws.http-client.max-concurrency", "10000");
        defaultExpectedKinesisClientConfigurations.put("aws.http-client.read-timeout", "360000");
        defaultExpectedKinesisClientConfigurations.put("aws.http.protocol.version", "HTTP2");
        return defaultExpectedKinesisClientConfigurations;
    }
}

