/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.compress.writers;

import java.io.IOException;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.compress.extractor.Extractor;
import org.apache.flink.util.Preconditions;

public class NoCompressionBulkWriter<T>
implements BulkWriter<T> {
    private final Extractor<T> extractor;
    private final FSDataOutputStream outputStream;

    public NoCompressionBulkWriter(FSDataOutputStream outputStream, Extractor<T> extractor) {
        this.outputStream = (FSDataOutputStream)Preconditions.checkNotNull((Object)outputStream);
        this.extractor = (Extractor)Preconditions.checkNotNull(extractor);
    }

    public void addElement(T element) throws IOException {
        this.outputStream.write(this.extractor.extract(element));
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void finish() throws IOException {
        this.outputStream.sync();
    }
}

