/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import org.apache.flink.client.CliFrontend;
import org.apache.flink.client.web.WebInterfaceServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFrontend {
    private static final Logger LOG = LoggerFactory.getLogger(WebFrontend.class);

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"Web Client", (String[])args);
        EnvironmentInformation.checkJavaVersion();
        if (args.length < 2 || !args[0].equals("--configDir")) {
            LOG.error("Wrong command line arguments. Usage: WebFrontend --configDir <directory>");
            System.exit(1);
        }
        try {
            String configDir = args[1];
            GlobalConfiguration.loadConfiguration((String)configDir);
            Configuration config = GlobalConfiguration.getConfiguration();
            config.setString("flink.base.dir.path", configDir + "/..");
            int port = config.getInteger("webclient.port", 8080);
            CliFrontend.webFrontend = true;
            WebInterfaceServer server = new WebInterfaceServer(args[1], config, port);
            LOG.info("Starting web frontend server on port " + port + '.');
            server.start();
            server.join();
        }
        catch (Throwable t) {
            LOG.error("Exception while starting the web server: " + t.getMessage(), t);
            System.exit(2);
        }
    }
}

