/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;

public class RemoteExecutor
extends PlanExecutor {
    private final Object lock = new Object();
    private final List<URL> jarFiles;
    private final List<URL> globalClasspaths;
    private final Configuration clientConfiguration;
    private Client client;
    private int defaultParallelism = 1;

    public RemoteExecutor(String hostname, int port) {
        this(hostname, port, new Configuration(), Collections.emptyList(), Collections.emptyList());
    }

    public RemoteExecutor(String hostname, int port, URL jarFile) {
        this(hostname, port, new Configuration(), Collections.singletonList(jarFile), Collections.emptyList());
    }

    public RemoteExecutor(String hostport, URL jarFile) {
        this(RemoteExecutor.getInetFromHostport(hostport), new Configuration(), Collections.singletonList(jarFile), Collections.emptyList());
    }

    public RemoteExecutor(String hostname, int port, List<URL> jarFiles) {
        this(new InetSocketAddress(hostname, port), new Configuration(), jarFiles, Collections.emptyList());
    }

    public RemoteExecutor(String hostname, int port, Configuration clientConfiguration) {
        this(hostname, port, clientConfiguration, Collections.emptyList(), Collections.emptyList());
    }

    public RemoteExecutor(String hostname, int port, Configuration clientConfiguration, URL jarFile) {
        this(hostname, port, clientConfiguration, Collections.singletonList(jarFile), Collections.emptyList());
    }

    public RemoteExecutor(String hostport, Configuration clientConfiguration, URL jarFile) {
        this(RemoteExecutor.getInetFromHostport(hostport), clientConfiguration, Collections.singletonList(jarFile), Collections.emptyList());
    }

    public RemoteExecutor(String hostname, int port, Configuration clientConfiguration, List<URL> jarFiles, List<URL> globalClasspaths) {
        this(new InetSocketAddress(hostname, port), clientConfiguration, jarFiles, globalClasspaths);
    }

    public RemoteExecutor(InetSocketAddress inet, Configuration clientConfiguration, List<URL> jarFiles, List<URL> globalClasspaths) {
        this.clientConfiguration = clientConfiguration;
        this.jarFiles = jarFiles;
        this.globalClasspaths = globalClasspaths;
        clientConfiguration.setString("jobmanager.rpc.address", inet.getHostName());
        clientConfiguration.setInteger("jobmanager.rpc.port", inet.getPort());
    }

    public void setDefaultParallelism(int defaultParallelism) {
        if (defaultParallelism < 1) {
            throw new IllegalArgumentException("The default parallelism must be at least one");
        }
        this.defaultParallelism = defaultParallelism;
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.client != null) {
                throw new IllegalStateException("The remote executor was already started.");
            }
            this.client = new Client(this.clientConfiguration);
            this.client.setPrintStatusDuringExecution(this.isPrintingStatusDuringExecution());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.client != null) {
                this.client.shutdown();
                this.client = null;
            }
        }
    }

    public boolean isRunning() {
        return this.client != null;
    }

    public JobExecutionResult executePlan(Plan plan) throws Exception {
        if (plan == null) {
            throw new IllegalArgumentException("The plan may not be null.");
        }
        JobWithJars p = new JobWithJars(plan, this.jarFiles, this.globalClasspaths);
        return this.executePlanWithJars(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutionResult executePlanWithJars(JobWithJars program) throws Exception {
        if (program == null) {
            throw new IllegalArgumentException("The job may not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            JobExecutionResult jobExecutionResult;
            block10: {
                boolean shutDownAtEnd;
                if (this.client == null) {
                    shutDownAtEnd = true;
                    this.start();
                } else {
                    shutDownAtEnd = false;
                }
                try {
                    jobExecutionResult = this.client.runBlocking(program, this.defaultParallelism);
                    if (!shutDownAtEnd) break block10;
                }
                catch (Throwable throwable) {
                    if (shutDownAtEnd) {
                        this.stop();
                    }
                    throw throwable;
                }
                this.stop();
            }
            return jobExecutionResult;
        }
    }

    public String getOptimizerPlanAsJSON(Plan plan) throws Exception {
        Optimizer opt = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), new Configuration());
        OptimizedPlan optPlan = opt.compile(plan);
        return new PlanJSONDumpGenerator().getOptimizerPlanAsJSON(optPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession(JobID jobID) throws Exception {
        if (jobID == null) {
            throw new NullPointerException("The supplied jobID must not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            boolean shutDownAtEnd;
            if (this.client == null) {
                shutDownAtEnd = true;
                this.start();
            } else {
                shutDownAtEnd = false;
            }
            try {
                this.client.endSession(jobID);
            }
            finally {
                if (shutDownAtEnd) {
                    this.stop();
                }
            }
        }
    }

    private static InetSocketAddress getInetFromHostport(String hostport) {
        URI uri;
        try {
            uri = new URI("my://" + hostport);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not identify hostname and port in '" + hostport + "'.", e);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || port == -1) {
            throw new RuntimeException("Could not identify hostname and port in '" + hostport + "'.");
        }
        return new InetSocketAddress(host, port);
    }
}

