/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.functions.PatternProcessFunction;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.CepRuntimeContext;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.utils.CepOperatorBuilder;
import org.apache.flink.cep.utils.CepOperatorTestUtilities;
import org.apache.flink.cep.utils.EventBuilder;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CepRuntimeContextTest
extends TestLogger {
    @Test
    public void testCepRuntimeContextIsSetInNFA() throws Exception {
        NFA mockNFA = (NFA)Mockito.mock(NFA.class);
        try (OneInputStreamOperatorTestHarness<Event, Map<String, List<Event>>> harness = CepOperatorTestUtilities.getCepTestHarness(CepOperatorBuilder.createOperatorForNFA((NFA<Event>)mockNFA).build());){
            harness.open();
            ((NFA)Mockito.verify((Object)mockNFA)).open((RuntimeContext)ArgumentMatchers.any(CepRuntimeContext.class), (Configuration)ArgumentMatchers.any(Configuration.class));
        }
    }

    @Test
    public void testCepRuntimeContextIsSetInProcessFunction() throws Exception {
        VerifyRuntimeContextProcessFunction processFunction = new VerifyRuntimeContextProcessFunction();
        try (OneInputStreamOperatorTestHarness<Event, Event> harness = CepOperatorTestUtilities.getCepTestHarness(CepOperatorBuilder.createOperatorForNFA(this.getSingleElementAlwaysTrueNFA()).withFunction(processFunction).build());){
            harness.open();
            Event record = EventBuilder.event().withName("A").build();
            harness.processElement((Object)record, 0L);
            MockProcessFunctionAsserter.assertFunction(processFunction).checkOpenCalled().checkCloseCalled().checkProcessMatchCalled();
        }
    }

    private NFA<Event> getSingleElementAlwaysTrueNFA() {
        return NFACompiler.compileFactory((Pattern)Pattern.begin((String)"A"), (boolean)false).createNFA();
    }

    @Test
    public void testCepRuntimeContext() {
        String taskName = "foobarTask";
        OperatorMetricGroup metricGroup = UnregisteredMetricsGroup.createOperatorMetricGroup();
        int numberOfParallelSubtasks = 42;
        int indexOfSubtask = 43;
        int attemptNumber = 1337;
        String taskNameWithSubtask = "barfoo";
        ExecutionConfig executionConfig = (ExecutionConfig)Mockito.mock(ExecutionConfig.class);
        ClassLoader userCodeClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        DistributedCache distributedCache = (DistributedCache)Mockito.mock(DistributedCache.class);
        RuntimeContext mockedRuntimeContext = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        Mockito.when((Object)mockedRuntimeContext.getTaskName()).thenReturn((Object)"foobarTask");
        Mockito.when((Object)mockedRuntimeContext.getMetricGroup()).thenReturn((Object)metricGroup);
        Mockito.when((Object)mockedRuntimeContext.getNumberOfParallelSubtasks()).thenReturn((Object)42);
        Mockito.when((Object)mockedRuntimeContext.getIndexOfThisSubtask()).thenReturn((Object)43);
        Mockito.when((Object)mockedRuntimeContext.getAttemptNumber()).thenReturn((Object)1337);
        Mockito.when((Object)mockedRuntimeContext.getTaskNameWithSubtasks()).thenReturn((Object)"barfoo");
        Mockito.when((Object)mockedRuntimeContext.getExecutionConfig()).thenReturn((Object)executionConfig);
        Mockito.when((Object)mockedRuntimeContext.getUserCodeClassLoader()).thenReturn((Object)userCodeClassLoader);
        Mockito.when((Object)mockedRuntimeContext.getDistributedCache()).thenReturn((Object)distributedCache);
        CepRuntimeContext runtimeContext = new CepRuntimeContext(mockedRuntimeContext);
        Assert.assertEquals((Object)"foobarTask", (Object)runtimeContext.getTaskName());
        Assert.assertEquals((Object)metricGroup, (Object)runtimeContext.getMetricGroup());
        Assert.assertEquals((long)42L, (long)runtimeContext.getNumberOfParallelSubtasks());
        Assert.assertEquals((long)43L, (long)runtimeContext.getIndexOfThisSubtask());
        Assert.assertEquals((long)1337L, (long)runtimeContext.getAttemptNumber());
        Assert.assertEquals((Object)"barfoo", (Object)runtimeContext.getTaskNameWithSubtasks());
        Assert.assertEquals((Object)executionConfig, (Object)runtimeContext.getExecutionConfig());
        Assert.assertEquals((Object)userCodeClassLoader, (Object)runtimeContext.getUserCodeClassLoader());
        Assert.assertEquals((Object)distributedCache, (Object)runtimeContext.getDistributedCache());
        try {
            runtimeContext.getState(new ValueStateDescriptor("foobar", Integer.class, (Object)42));
            Assert.fail((String)"Expected getState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getListState(new ListStateDescriptor("foobar", Integer.class));
            Assert.fail((String)"Expected getListState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getReducingState(new ReducingStateDescriptor("foobar", (ReduceFunction)Mockito.mock(ReduceFunction.class), Integer.class));
            Assert.fail((String)"Expected getReducingState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getAggregatingState(new AggregatingStateDescriptor("foobar", (AggregateFunction)Mockito.mock(AggregateFunction.class), Integer.class));
            Assert.fail((String)"Expected getAggregatingState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getMapState(new MapStateDescriptor("foobar", Integer.class, String.class));
            Assert.fail((String)"Expected getMapState to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.addAccumulator("foobar", (Accumulator)Mockito.mock(Accumulator.class));
            Assert.fail((String)"Expected addAccumulator to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getAccumulator("foobar");
            Assert.fail((String)"Expected getAccumulator to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getIntCounter("foobar");
            Assert.fail((String)"Expected getIntCounter to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getLongCounter("foobar");
            Assert.fail((String)"Expected getLongCounter to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getDoubleCounter("foobar");
            Assert.fail((String)"Expected getDoubleCounter to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getHistogram("foobar");
            Assert.fail((String)"Expected getHistogram to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.hasBroadcastVariable("foobar");
            Assert.fail((String)"Expected hasBroadcastVariable to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getBroadcastVariable("foobar");
            Assert.fail((String)"Expected getBroadcastVariable to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            runtimeContext.getBroadcastVariableWithInitializer("foobar", (BroadcastVariableInitializer)Mockito.mock(BroadcastVariableInitializer.class));
            Assert.fail((String)"Expected getBroadcastVariableWithInitializer to fail with unsupported operation exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static class VerifyRuntimeContextProcessFunction
    extends PatternProcessFunction<Event, Event> {
        boolean openCalled = false;
        boolean closeCalled = false;
        boolean processMatchCalled = false;

        private VerifyRuntimeContextProcessFunction() {
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            this.verifyContext();
            this.openCalled = true;
        }

        private void verifyContext() {
            if (!(this.getRuntimeContext() instanceof CepRuntimeContext)) {
                Assert.fail((String)"Runtime context was not wrapped in CepRuntimeContext");
            }
        }

        public void close() throws Exception {
            super.close();
            this.verifyContext();
            this.closeCalled = true;
        }

        public void processMatch(Map<String, List<Event>> match, PatternProcessFunction.Context ctx, Collector<Event> out) throws Exception {
            this.verifyContext();
            this.processMatchCalled = true;
        }
    }

    static class MockProcessFunctionAsserter {
        private final VerifyRuntimeContextProcessFunction function;

        static MockProcessFunctionAsserter assertFunction(VerifyRuntimeContextProcessFunction function) {
            return new MockProcessFunctionAsserter(function);
        }

        private MockProcessFunctionAsserter(VerifyRuntimeContextProcessFunction function) {
            this.function = function;
        }

        MockProcessFunctionAsserter checkOpenCalled() {
            Assert.assertThat((Object)this.function.openCalled, (Matcher)Is.is((Object)true));
            return this;
        }

        MockProcessFunctionAsserter checkCloseCalled() {
            Assert.assertThat((Object)this.function.openCalled, (Matcher)Is.is((Object)true));
            return this;
        }

        MockProcessFunctionAsserter checkProcessMatchCalled() {
            Assert.assertThat((Object)this.function.processMatchCalled, (Matcher)Is.is((Object)true));
            return this;
        }
    }
}

