/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.compiler;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.SubEvent;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransition;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.WithinType;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava31.com.google.common.collect.Sets;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NFACompilerTest
extends TestLogger {
    private static final SimpleCondition<Event> startFilter = SimpleCondition.of((FilterFunction & Serializable)value -> value.getPrice() > 2.0);
    private static final SimpleCondition<Event> endFilter = SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end"));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testNFACompilerUniquePatternName() {
        this.expectedException.expect(MalformedPatternException.class);
        this.expectedException.expectMessage("Duplicate pattern name: start. Names must be unique.");
        Pattern invalidPattern = Pattern.begin((String)"start").where((IterativeCondition)new TestFilter()).followedBy("middle").where((IterativeCondition)new TestFilter()).followedBy("start").where((IterativeCondition)new TestFilter());
        NFAUtils.compile(invalidPattern, false);
    }

    @Test
    public void testNFACompilerPatternEndsWithNotFollowedBy() {
        this.expectedException.expect(MalformedPatternException.class);
        this.expectedException.expectMessage("NotFollowedBy is not supported without windowTime as a last part of a Pattern!");
        Pattern invalidPattern = Pattern.begin((String)"start").where((IterativeCondition)new TestFilter()).followedBy("middle").where((IterativeCondition)new TestFilter()).notFollowedBy("end").where((IterativeCondition)new TestFilter());
        NFAUtils.compile(invalidPattern, false);
    }

    @Test
    public void testNFACompilerWithSimplePattern() {
        Pattern pattern = Pattern.begin((String)"start").where(startFilter).followedBy("middle").subtype(SubEvent.class).next("end").where(endFilter);
        NFA nfa = NFAUtils.compile(pattern, false);
        Collection states = nfa.getStates();
        Assert.assertEquals((long)4L, (long)states.size());
        HashMap<String, State> stateMap = new HashMap<String, State>();
        for (State state : states) {
            stateMap.put(state.getName(), state);
        }
        Assert.assertTrue((boolean)stateMap.containsKey("start"));
        State startState = (State)stateMap.get("start");
        Assert.assertTrue((boolean)startState.isStart());
        Set<Tuple2<String, StateTransitionAction>> startTransitions = this.unfoldTransitions(startState);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Tuple2[]{Tuple2.of((Object)"middle", (Object)StateTransitionAction.TAKE)}), startTransitions);
        Assert.assertTrue((boolean)stateMap.containsKey("middle"));
        State middleState = (State)stateMap.get("middle");
        Set<Tuple2<String, StateTransitionAction>> middleTransitions = this.unfoldTransitions(middleState);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Tuple2[]{Tuple2.of((Object)"middle", (Object)StateTransitionAction.IGNORE), Tuple2.of((Object)"end", (Object)StateTransitionAction.TAKE)}), middleTransitions);
        Assert.assertTrue((boolean)stateMap.containsKey("end"));
        State endState = (State)stateMap.get("end");
        Set<Tuple2<String, StateTransitionAction>> endTransitions = this.unfoldTransitions(endState);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Tuple2[]{Tuple2.of((Object)"$endState$", (Object)StateTransitionAction.TAKE)}), endTransitions);
        Assert.assertTrue((boolean)stateMap.containsKey("$endState$"));
        State endingState = (State)stateMap.get("$endState$");
        Assert.assertTrue((boolean)endingState.isFinal());
        Assert.assertEquals((long)0L, (long)endingState.getStateTransitions().size());
    }

    @Test
    public void testNFACompilerPatternNotFollowedByWithIn() {
        Pattern pattern = Pattern.begin((String)"start").where(startFilter).notFollowedBy("middle").where(endFilter).within(Time.milliseconds((long)1L));
        NFA nfa = NFAUtils.compile(pattern, false);
        Collection states = nfa.getStates();
        Assert.assertEquals((long)4L, (long)states.size());
        HashMap<String, State> stateMap = new HashMap<String, State>();
        for (State state : states) {
            stateMap.put(state.getName(), state);
        }
        Assert.assertTrue((boolean)stateMap.containsKey("start"));
        State startState = (State)stateMap.get("start");
        Assert.assertTrue((boolean)startState.isStart());
        Set<Tuple2<String, StateTransitionAction>> startTransitions = this.unfoldTransitions(startState);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Tuple2[]{Tuple2.of((Object)"middle", (Object)StateTransitionAction.TAKE)}), startTransitions);
        Assert.assertTrue((boolean)stateMap.containsKey("middle"));
        State middleState = (State)stateMap.get("middle");
        Assert.assertTrue((boolean)middleState.isPending());
        Set<Tuple2<String, StateTransitionAction>> middleTransitions = this.unfoldTransitions(middleState);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Tuple2[]{Tuple2.of((Object)"middle", (Object)StateTransitionAction.IGNORE), Tuple2.of((Object)"middle:0", (Object)StateTransitionAction.PROCEED)}), middleTransitions);
        Assert.assertTrue((boolean)stateMap.containsKey("middle:0"));
        State middle0State = (State)stateMap.get("middle:0");
        Assert.assertTrue((boolean)middle0State.isStop());
        Set<Tuple2<String, StateTransitionAction>> middle0Transitions = this.unfoldTransitions(middle0State);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Tuple2[]{Tuple2.of((Object)"middle:0", (Object)StateTransitionAction.TAKE)}), middle0Transitions);
        Assert.assertTrue((boolean)stateMap.containsKey("$endState$"));
        State endingState = (State)stateMap.get("$endState$");
        Assert.assertTrue((boolean)endingState.isFinal());
        Assert.assertEquals((long)0L, (long)endingState.getStateTransitions().size());
    }

    @Test
    public void testNoUnnecessaryStateCopiesCreated() {
        Pattern pattern = Pattern.begin((String)"start").where(startFilter).notFollowedBy("not").where(startFilter).followedBy("oneOrMore").where(startFilter).oneOrMore().followedBy("end").where(endFilter);
        NFACompiler.NFAFactoryCompiler nfaFactoryCompiler = new NFACompiler.NFAFactoryCompiler(pattern);
        nfaFactoryCompiler.compileFactory();
        int endStateCount = 0;
        for (State state : nfaFactoryCompiler.getStates()) {
            if (!state.getName().equals("end")) continue;
            ++endStateCount;
        }
        Assert.assertEquals((long)1L, (long)endStateCount);
    }

    @Test
    public void testSkipToNotExistsMatchingPattern() {
        this.expectedException.expect(MalformedPatternException.class);
        this.expectedException.expectMessage("The pattern name specified in AfterMatchSkipStrategy can not be found in the given Pattern");
        Pattern invalidPattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"midd")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("d"))).oneOrMore().optional().next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c")));
        NFAUtils.compile(invalidPattern, false);
    }

    private <T> Set<Tuple2<String, StateTransitionAction>> unfoldTransitions(State<T> state) {
        HashSet<Tuple2<String, StateTransitionAction>> transitions = new HashSet<Tuple2<String, StateTransitionAction>>();
        for (StateTransition transition : state.getStateTransitions()) {
            transitions.add((Tuple2<String, StateTransitionAction>)Tuple2.of((Object)transition.getTargetState().getName(), (Object)transition.getAction()));
        }
        return transitions;
    }

    @Test
    public void testCheckingEmptyMatches() {
        Assert.assertThat((Object)NFACompiler.canProduceEmptyMatches((Pattern)Pattern.begin((String)"a").optional()), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)NFACompiler.canProduceEmptyMatches((Pattern)Pattern.begin((String)"a").oneOrMore().optional()), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)NFACompiler.canProduceEmptyMatches((Pattern)Pattern.begin((String)"a").oneOrMore().optional().next("b").optional()), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)NFACompiler.canProduceEmptyMatches((Pattern)Pattern.begin((String)"a")), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)NFACompiler.canProduceEmptyMatches((Pattern)Pattern.begin((String)"a").oneOrMore()), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)NFACompiler.canProduceEmptyMatches((Pattern)Pattern.begin((String)"a").oneOrMore().next("b").optional()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testWindowTimeCorrectlySet() {
        Pattern pattern = Pattern.begin((String)"start").followedBy("middle").within(Time.seconds((long)10L)).followedBy("then").within(Time.seconds((long)20L)).followedBy("end");
        NFACompiler.NFAFactoryCompiler factory = new NFACompiler.NFAFactoryCompiler(pattern);
        factory.compileFactory();
        Assert.assertEquals((long)10000L, (long)factory.getWindowTime());
    }

    @Test
    public void testWindowTimesCorrectlySet() {
        Pattern pattern = Pattern.begin((String)"start").followedBy("middle").within(Time.seconds((long)10L), WithinType.PREVIOUS_AND_CURRENT).followedBy("then").within(Time.seconds((long)20L), WithinType.PREVIOUS_AND_CURRENT).followedBy("end");
        NFACompiler.NFAFactoryCompiler factory = new NFACompiler.NFAFactoryCompiler(pattern);
        factory.compileFactory();
        HashMap<String, Long> expectedWindowTimes = new HashMap<String, Long>();
        expectedWindowTimes.put("middle", Time.seconds((long)10L).toMilliseconds());
        expectedWindowTimes.put("then", Time.seconds((long)20L).toMilliseconds());
        Assert.assertEquals(expectedWindowTimes, (Object)factory.getWindowTimes());
    }

    @Test
    public void testMultipleWindowTimeWithZeroLength() {
        Pattern pattern = Pattern.begin((String)"start").followedBy("middle").within(Time.seconds((long)10L)).followedBy("then").within(Time.seconds((long)0L)).followedBy("end");
        NFACompiler.NFAFactoryCompiler factory = new NFACompiler.NFAFactoryCompiler(pattern);
        factory.compileFactory();
        Assert.assertEquals((long)0L, (long)factory.getWindowTime());
    }

    @Test
    public void testCheckPatternWindowTimes() {
        this.expectedException.expect(MalformedPatternException.class);
        this.expectedException.expectMessage("The window length between the previous and current event cannot be larger than the window length between the first and last event for a Pattern.");
        Pattern pattern = Pattern.begin((String)"start").followedBy("middle").within(Time.seconds((long)3L), WithinType.PREVIOUS_AND_CURRENT).followedBy("then").within(Time.seconds((long)1L), WithinType.PREVIOUS_AND_CURRENT).followedBy("end").within(Time.milliseconds((long)2L));
        NFACompiler.NFAFactoryCompiler factory = new NFACompiler.NFAFactoryCompiler(pattern);
        factory.compileFactory();
    }

    private static class TestFilter
    extends SimpleCondition<Event> {
        private static final long serialVersionUID = -3863103355752267133L;

        private TestFilter() {
        }

        public boolean filter(Event value) throws Exception {
            throw new RuntimeException("It should never arrive here.");
        }
    }
}

