/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimesRangeITCase
extends TestLogger {
    @Parameterized.Parameter
    public Time time;

    @Parameterized.Parameters(name="Times Range Time: {0}")
    public static Collection<Time> parameters() {
        return Arrays.asList(null, Time.milliseconds((long)3L));
    }

    @Test
    public void testTimesRange() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(1, 3, this.time).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1})}));
    }

    @Test
    public void testTimesRangeFromZero() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 4L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(0, 2, this.time).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, end1}), Lists.newArrayList((Object[])new Event[]{startEvent, end1})}));
    }

    @Test
    public void testTimesRangeNonStrict() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(1, 3, this.time).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        ArrayList expectedPatterns = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end})});
        if (this.time == null) {
            expectedPatterns.addAll(Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent3, ConsecutiveData.end})}));
        }
        NFATestUtilities.comparePatterns(resultingPatterns, expectedPatterns);
    }

    @Test
    public void testTimesRangeStrict() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(0, 3, this.time).consecutive().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesRangeStrictOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(1, 3, this.time).consecutive().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesRangeStrictOptional1() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(1, 3, this.time).consecutive().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesRangeNonStrictOptional1() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(1, 3, this.time).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesRangeNonStrictOptional2() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 3, this.time).allowCombinations().optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        ArrayList expectedPatterns = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})});
        if (this.time == null) {
            expectedPatterns.add(Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}));
        }
        NFATestUtilities.comparePatterns(resultingPatterns, expectedPatterns);
    }

    @Test
    public void testTimesRangeNonStrictOptional3() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 3, this.time).optional().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesRangeNonStrictWithNext() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 3L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(23, "f", 1.0), 5L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 3, this.time).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        ArrayList expectedPatterns = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end})});
        if (this.time == null) {
            expectedPatterns.add(Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end}));
        }
        NFATestUtilities.comparePatterns(resultingPatterns, expectedPatterns);
    }

    @Test
    public void testTimesRangeNotStrictWithFollowedBy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 3, this.time).followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end})}));
    }

    @Test
    public void testTimesRangeNotStrictWithFollowedByAny() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.middleEvent3, 6L));
        inputEvents.add(new StreamRecord((Object)ConsecutiveData.end, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 3, this.time).allowCombinations().followedBy("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        ArrayList expectedPatterns = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent2, ConsecutiveData.end})});
        if (this.time == null) {
            expectedPatterns.addAll(Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent2, ConsecutiveData.middleEvent3, ConsecutiveData.end}), Lists.newArrayList((Object[])new Event[]{ConsecutiveData.startEvent, ConsecutiveData.middleEvent1, ConsecutiveData.middleEvent3, ConsecutiveData.end})}));
        }
        NFATestUtilities.comparePatterns(resultingPatterns, expectedPatterns);
    }

    private static class ConsecutiveData {
        private static final Event startEvent = new Event(40, "c", 1.0);
        private static final Event middleEvent1 = new Event(41, "a", 2.0);
        private static final Event middleEvent2 = new Event(42, "a", 3.0);
        private static final Event middleEvent3 = new Event(43, "a", 4.0);
        private static final Event end = new Event(44, "b", 5.0);

        private ConsecutiveData() {
        }
    }
}

