/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipPastLastStrategy;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.TestSharedBuffer;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AfterMatchSkipITCase
extends TestLogger {
    @Test
    public void testNoSkip() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a", 0.0);
        Event a2 = new Event(2, "a", 0.0);
        Event a3 = new Event(3, "a", 0.0);
        Event a4 = new Event(4, "a", 0.0);
        Event a5 = new Event(5, "a", 0.0);
        Event a6 = new Event(6, "a", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)a4));
        streamEvents.add(new StreamRecord((Object)a5));
        streamEvents.add(new StreamRecord((Object)a6));
        Pattern pattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(3);
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, a2, a3}), Lists.newArrayList((Object[])new Event[]{a2, a3, a4}), Lists.newArrayList((Object[])new Event[]{a3, a4, a5}), Lists.newArrayList((Object[])new Event[]{a4, a5, a6})}));
    }

    @Test
    public void testNoSkipWithFollowedByAny() throws Exception {
        List resultingPatterns = TwoVariablesFollowedByAny.compute((AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{TwoVariablesFollowedByAny.a1, TwoVariablesFollowedByAny.b1}), Lists.newArrayList((Object[])new Event[]{TwoVariablesFollowedByAny.a1, TwoVariablesFollowedByAny.b2}), Lists.newArrayList((Object[])new Event[]{TwoVariablesFollowedByAny.a2, TwoVariablesFollowedByAny.b2})}));
    }

    @Test
    public void testSkipToNextWithFollowedByAny() throws Exception {
        List resultingPatterns = TwoVariablesFollowedByAny.compute(AfterMatchSkipStrategy.skipToNext());
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{TwoVariablesFollowedByAny.a1, TwoVariablesFollowedByAny.b1}), Lists.newArrayList((Object[])new Event[]{TwoVariablesFollowedByAny.a2, TwoVariablesFollowedByAny.b2})}));
    }

    @Test
    public void testNoSkipWithQuantifierAtTheEnd() throws Exception {
        List resultingPatterns = QuantifierAtEndOfPattern.compute((AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip());
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{QuantifierAtEndOfPattern.a1, QuantifierAtEndOfPattern.b1, QuantifierAtEndOfPattern.b2, QuantifierAtEndOfPattern.b3}), Lists.newArrayList((Object[])new Event[]{QuantifierAtEndOfPattern.a1, QuantifierAtEndOfPattern.b1, QuantifierAtEndOfPattern.b2}), Lists.newArrayList((Object[])new Event[]{QuantifierAtEndOfPattern.a1, QuantifierAtEndOfPattern.b1})}));
    }

    @Test
    public void testSkipToNextWithQuantifierAtTheEnd() throws Exception {
        List resultingPatterns = QuantifierAtEndOfPattern.compute(AfterMatchSkipStrategy.skipToNext());
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{QuantifierAtEndOfPattern.a1, QuantifierAtEndOfPattern.b1})}));
    }

    @Test
    public void testSkipPastLast() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a", 0.0);
        Event a2 = new Event(2, "a", 0.0);
        Event a3 = new Event(3, "a", 0.0);
        Event a4 = new Event(4, "a", 0.0);
        Event a5 = new Event(5, "a", 0.0);
        Event a6 = new Event(6, "a", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)a4));
        streamEvents.add(new StreamRecord((Object)a5));
        streamEvents.add(new StreamRecord((Object)a6));
        Pattern pattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(3);
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, a2, a3}), Lists.newArrayList((Object[])new Event[]{a4, a5, a6})}));
    }

    @Test
    public void testSkipToFirst() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event ab1 = new Event(1, "ab", 0.0);
        Event ab2 = new Event(2, "ab", 0.0);
        Event ab3 = new Event(3, "ab", 0.0);
        Event ab4 = new Event(4, "ab", 0.0);
        Event ab5 = new Event(5, "ab", 0.0);
        Event ab6 = new Event(6, "ab", 0.0);
        streamEvents.add(new StreamRecord((Object)ab1));
        streamEvents.add(new StreamRecord((Object)ab2));
        streamEvents.add(new StreamRecord((Object)ab3));
        streamEvents.add(new StreamRecord((Object)ab4));
        streamEvents.add(new StreamRecord((Object)ab5));
        streamEvents.add(new StreamRecord((Object)ab6));
        Pattern pattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"end")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).times(2).next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).times(2);
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ab1, ab2, ab3, ab4}), Lists.newArrayList((Object[])new Event[]{ab3, ab4, ab5, ab6})}));
    }

    @Test
    public void testSkipToLast() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event ab1 = new Event(1, "ab", 0.0);
        Event ab2 = new Event(2, "ab", 0.0);
        Event ab3 = new Event(3, "ab", 0.0);
        Event ab4 = new Event(4, "ab", 0.0);
        Event ab5 = new Event(5, "ab", 0.0);
        Event ab6 = new Event(6, "ab", 0.0);
        Event ab7 = new Event(7, "ab", 0.0);
        streamEvents.add(new StreamRecord((Object)ab1));
        streamEvents.add(new StreamRecord((Object)ab2));
        streamEvents.add(new StreamRecord((Object)ab3));
        streamEvents.add(new StreamRecord((Object)ab4));
        streamEvents.add(new StreamRecord((Object)ab5));
        streamEvents.add(new StreamRecord((Object)ab6));
        streamEvents.add(new StreamRecord((Object)ab7));
        Pattern pattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"end")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).times(2).next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).times(2);
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ab1, ab2, ab3, ab4}), Lists.newArrayList((Object[])new Event[]{ab4, ab5, ab6, ab7})}));
    }

    @Test
    public void testSkipPastLast2() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event a2 = new Event(2, "a2", 0.0);
        Event b1 = new Event(3, "b1", 0.0);
        Event b2 = new Event(4, "b2", 0.0);
        Event c1 = new Event(5, "c1", 0.0);
        Event c2 = new Event(6, "c2", 0.0);
        Event d1 = new Event(7, "d1", 0.0);
        Event d2 = new Event(7, "d2", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)b1));
        streamEvents.add(new StreamRecord((Object)b2));
        streamEvents.add(new StreamRecord((Object)c1));
        streamEvents.add(new StreamRecord((Object)c2));
        streamEvents.add(new StreamRecord((Object)d1));
        streamEvents.add(new StreamRecord((Object)d2));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).followedByAny("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).followedByAny("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c"))).followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("d")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Collections.singletonList(Lists.newArrayList((Object[])new Event[]{a1, b1, c1, d1})));
    }

    @Test
    public void testSkipPastLast3() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event c = new Event(2, "c", 0.0);
        Event a2 = new Event(3, "a2", 0.0);
        Event b2 = new Event(4, "b2", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)c));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)b2));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a2, b2})}));
    }

    @Test
    public void testSkipToFirstWithOptionalMatch() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event ab1 = new Event(1, "ab1", 0.0);
        Event c1 = new Event(2, "c1", 0.0);
        Event ab2 = new Event(3, "ab2", 0.0);
        Event c2 = new Event(4, "c2", 0.0);
        streamEvents.add(new StreamRecord((Object)ab1));
        streamEvents.add(new StreamRecord((Object)c1));
        streamEvents.add(new StreamRecord((Object)ab2));
        streamEvents.add(new StreamRecord((Object)c2));
        Pattern pattern = Pattern.begin((String)"x", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"b")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("x"))).oneOrMore().optional().next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).next("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ab1, c1}), Lists.newArrayList((Object[])new Event[]{ab2, c2})}));
    }

    @Test
    public void testSkipToFirstAtStartPosition() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event ab1 = new Event(1, "ab1", 0.0);
        Event c1 = new Event(2, "c1", 0.0);
        Event ab2 = new Event(3, "ab2", 0.0);
        Event c2 = new Event(4, "c2", 0.0);
        streamEvents.add(new StreamRecord((Object)ab1));
        streamEvents.add(new StreamRecord((Object)c1));
        streamEvents.add(new StreamRecord((Object)ab2));
        streamEvents.add(new StreamRecord((Object)c2));
        Pattern pattern = Pattern.begin((String)"b", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"b")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).next("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{ab1, c1}), Lists.newArrayList((Object[])new Event[]{ab2, c2})}));
    }

    @Test
    public void testSkipToFirstWithOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event b1 = new Event(2, "b1", 0.0);
        Event a2 = new Event(3, "a2", 0.0);
        Event b2 = new Event(4, "b2", 0.0);
        Event b3 = new Event(5, "b3", 0.0);
        Event a3 = new Event(3, "a3", 0.0);
        Event b4 = new Event(4, "b4", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)b1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)b2));
        streamEvents.add(new StreamRecord((Object)b3));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)b4));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"b")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).oneOrMore().consecutive();
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, b1}), Lists.newArrayList((Object[])new Event[]{a2, b2}), Lists.newArrayList((Object[])new Event[]{a3, b4})}));
    }

    @Test(expected=FlinkRuntimeException.class)
    public void testSkipToFirstElementOfMatch() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"a").throwExceptionOnMiss()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
    }

    @Test(expected=FlinkRuntimeException.class)
    public void testSkipToFirstNonExistentPosition() throws Exception {
        MissedSkipTo.compute((AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"b").throwExceptionOnMiss());
    }

    @Test
    public void testSkipToFirstNonExistentPositionWithoutException() throws Exception {
        List<List<Event>> resultingPatterns = MissedSkipTo.compute((AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"b"));
        NFATestUtilities.comparePatterns(resultingPatterns, Collections.singletonList(Lists.newArrayList((Object[])new Event[]{MissedSkipTo.a, MissedSkipTo.c})));
    }

    @Test(expected=FlinkRuntimeException.class)
    public void testSkipToLastNonExistentPosition() throws Exception {
        MissedSkipTo.compute((AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"b").throwExceptionOnMiss());
    }

    @Test
    public void testSkipToLastNonExistentPositionWithoutException() throws Exception {
        List<List<Event>> resultingPatterns = MissedSkipTo.compute((AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"b"));
        NFATestUtilities.comparePatterns(resultingPatterns, Collections.singletonList(Lists.newArrayList((Object[])new Event[]{MissedSkipTo.a, MissedSkipTo.c})));
    }

    @Test
    public void testSkipToLastWithOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event b1 = new Event(2, "b1", 0.0);
        Event a2 = new Event(3, "a2", 0.0);
        Event b2 = new Event(4, "b2", 0.0);
        Event b3 = new Event(5, "b3", 0.0);
        Event a3 = new Event(3, "a3", 0.0);
        Event b4 = new Event(4, "b4", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)b1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)b2));
        streamEvents.add(new StreamRecord((Object)b3));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)b4));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"b")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).oneOrMore().consecutive();
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, b1}), Lists.newArrayList((Object[])new Event[]{a2, b2}), Lists.newArrayList((Object[])new Event[]{a3, b4})}));
    }

    @Test
    public void testSkipPastLastWithOneOrMoreAtBeginning() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event a2 = new Event(2, "a2", 0.0);
        Event a3 = new Event(3, "a3", 0.0);
        Event b1 = new Event(4, "b1", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)b1));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipPastLastEvent()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).oneOrMore().consecutive().greedy().next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Collections.singletonList(Lists.newArrayList((Object[])new Event[]{a1, a2, a3, b1})));
    }

    @Test
    public void testSkipToLastWithOneOrMoreAtBeginning() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event a2 = new Event(2, "a2", 0.0);
        Event a3 = new Event(3, "a3", 0.0);
        Event b1 = new Event(4, "b1", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)b1));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToLast((String)"a")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).oneOrMore().consecutive().greedy().next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, a2, a3, b1}), Lists.newArrayList((Object[])new Event[]{a3, b1})}));
    }

    @Test
    public void testSkipToFirstWithOneOrMoreAtBeginning() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event a2 = new Event(2, "a2", 0.0);
        Event a3 = new Event(3, "a3", 0.0);
        Event b1 = new Event(4, "b1", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)b1));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"a")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).oneOrMore().consecutive().greedy().next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, a2, a3, b1}), Lists.newArrayList((Object[])new Event[]{a2, a3, b1}), Lists.newArrayList((Object[])new Event[]{a3, b1})}));
    }

    @Test
    public void testNoSkipWithOneOrMoreAtBeginning() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event a2 = new Event(2, "a2", 0.0);
        Event a3 = new Event(3, "a3", 0.0);
        Event b1 = new Event(4, "b1", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)a3));
        streamEvents.add(new StreamRecord((Object)b1));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.noSkip()).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).oneOrMore().consecutive().greedy().next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, a2, a3, b1}), Lists.newArrayList((Object[])new Event[]{a2, a3, b1}), Lists.newArrayList((Object[])new Event[]{a3, b1})}));
    }

    @Test
    public void testSkipToFirstDiscarding() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a = new Event(1, "a", 0.0);
        Event b = new Event(2, "b", 0.0);
        Event c1 = new Event(3, "c1", 0.0);
        Event c2 = new Event(4, "c2", 0.0);
        Event c3 = new Event(5, "c3", 0.0);
        Event d = new Event(6, "d", 0.0);
        streamEvents.add(new StreamRecord((Object)a));
        streamEvents.add(new StreamRecord((Object)b));
        streamEvents.add(new StreamRecord((Object)c1));
        streamEvents.add(new StreamRecord((Object)c2));
        streamEvents.add(new StreamRecord((Object)c3));
        streamEvents.add(new StreamRecord((Object)d));
        Pattern pattern = Pattern.begin((String)"a or c", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"c*")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a") || value.getName().contains("c"))).followedBy("b or c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b") || value.getName().contains("c"))).followedBy("c*").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c"))).oneOrMore().greedy().followedBy("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("d")));
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a, b, c1, c2, c3, d}), Lists.newArrayList((Object[])new Event[]{c1, c2, c3, d})}));
    }

    @Test
    public void testSkipBeforeOtherAlreadyCompleted() throws Exception {
        ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(1, "a1", 0.0);
        Event c1 = new Event(2, "c1", 0.0);
        Event a2 = new Event(3, "a2", 1.0);
        Event c2 = new Event(4, "c2", 0.0);
        Event b1 = new Event(5, "b1", 1.0);
        Event b2 = new Event(6, "b2", 0.0);
        streamEvents.add(new StreamRecord((Object)a1));
        streamEvents.add(new StreamRecord((Object)c1));
        streamEvents.add(new StreamRecord((Object)a2));
        streamEvents.add(new StreamRecord((Object)c2));
        streamEvents.add(new StreamRecord((Object)b1));
        streamEvents.add(new StreamRecord((Object)b2));
        Pattern pattern = Pattern.begin((String)"a", (AfterMatchSkipStrategy)AfterMatchSkipStrategy.skipToFirst((String)"c")).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).followedBy("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c"))).followedBy("b").where((IterativeCondition)new IterativeCondition<Event>(){

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                return value.getName().contains("b") && ((Event)ctx.getEventsForPattern("a").iterator().next()).getPrice() == value.getPrice();
            }
        });
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(streamEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, c1, b2}), Lists.newArrayList((Object[])new Event[]{a2, c2, b1})}));
    }

    @Test
    public void testSharedBufferIsProperlyCleared() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        for (int i = 0; i < 4; ++i) {
            inputEvents.add(new StreamRecord((Object)new Event(1, "a", 1.0), (long)i));
        }
        SkipPastLastStrategy matchSkipStrategy = AfterMatchSkipStrategy.skipPastLastEvent();
        Pattern pattern = Pattern.begin((String)"start", (AfterMatchSkipStrategy)matchSkipStrategy).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> true)).times(2);
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer());
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).withSharedBuffer(sharedBuffer).build();
        nfaTestHarness.feedRecords(inputEvents);
        Assert.assertThat((Object)sharedBuffer.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    static class MissedSkipTo {
        static Event a = new Event(1, "a", 0.0);
        static Event c = new Event(4, "c", 0.0);

        MissedSkipTo() {
        }

        static List<List<Event>> compute(AfterMatchSkipStrategy skipStrategy) throws Exception {
            ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
            streamEvents.add(new StreamRecord((Object)a));
            streamEvents.add(new StreamRecord((Object)c));
            Pattern pattern = Pattern.begin((String)"a").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("a"))).next("b").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("b"))).oneOrMore().optional().consecutive().next("c").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().contains("c")));
            NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).withAfterMatchSkipStrategy(skipStrategy).build();
            return nfaTestHarness.feedRecords(streamEvents);
        }
    }

    static class QuantifierAtEndOfPattern {
        static Event a1 = new Event(1, "a", 0.0);
        static Event b1 = new Event(2, "b", 0.0);
        static Event b2 = new Event(4, "b", 0.0);
        static Event b3 = new Event(5, "b", 0.0);

        QuantifierAtEndOfPattern() {
        }

        private static List<List<Event>> compute(AfterMatchSkipStrategy skipStrategy) throws Exception {
            ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
            streamEvents.add(new StreamRecord((Object)a1));
            streamEvents.add(new StreamRecord((Object)b1));
            streamEvents.add(new StreamRecord((Object)b2));
            streamEvents.add(new StreamRecord((Object)b3));
            Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).oneOrMore();
            NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).withAfterMatchSkipStrategy(skipStrategy).build();
            return nfaTestHarness.feedRecords(streamEvents);
        }
    }

    static class TwoVariablesFollowedByAny {
        static Event a1 = new Event(1, "a", 0.0);
        static Event b1 = new Event(2, "b", 0.0);
        static Event a2 = new Event(4, "a", 0.0);
        static Event b2 = new Event(5, "b", 0.0);

        TwoVariablesFollowedByAny() {
        }

        private static List<List<Event>> compute(AfterMatchSkipStrategy skipStrategy) throws Exception {
            ArrayList<StreamRecord<Event>> streamEvents = new ArrayList<StreamRecord<Event>>();
            streamEvents.add(new StreamRecord((Object)a1));
            streamEvents.add(new StreamRecord((Object)b1));
            streamEvents.add(new StreamRecord((Object)a2));
            streamEvents.add(new StreamRecord((Object)b2));
            Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedByAny("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")));
            NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).withAfterMatchSkipStrategy(skipStrategy).build();
            return nfaTestHarness.feedRecords(streamEvents);
        }
    }
}

