/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class GreedyITCase
extends TestLogger {
    @Test
    public void testGreedyZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)a3, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d})}));
    }

    @Test
    public void testGreedyZeroOrMoreInBetween() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "dummy", 1111.0), 2L));
        inputEvents.add(new StreamRecord((Object)a1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "dummy", 1111.0), 4L));
        inputEvents.add(new StreamRecord((Object)a2, 5L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "dummy", 1111.0), 6L));
        inputEvents.add(new StreamRecord((Object)a3, 7L));
        inputEvents.add(new StreamRecord((Object)d, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d})}));
    }

    @Test
    public void testGreedyZeroOrMoreWithDummyEventsAfterQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "dummy", 2.0), 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, d})}));
    }

    @Test
    public void testGreedyZeroOrMoreWithDummyEventsBeforeQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "dummy", 2.0), 2L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d})}));
    }

    @Test
    public void testGreedyUntilZeroOrMoreWithDummyEventsAfterQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 3.0);
        Event a3 = new Event(43, "a", 3.0);
        Event d = new Event(45, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)a3, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "a", 4.0), 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().until((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getPrice() > 3.0)).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d})}));
    }

    @Test
    public void testGreedyUntilWithDummyEventsBeforeQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 3.0);
        Event a3 = new Event(43, "a", 3.0);
        Event d = new Event(45, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "a", 4.0), 2L));
        inputEvents.add(new StreamRecord((Object)a1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)a3, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().until((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getPrice() > 3.0)).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d})}));
    }

    @Test
    public void testGreedyOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)a3, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d})}));
    }

    @Test
    public void testGreedyOneOrMoreInBetween() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "dummy", 1111.0), 2L));
        inputEvents.add(new StreamRecord((Object)a1, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "dummy", 1111.0), 4L));
        inputEvents.add(new StreamRecord((Object)a2, 5L));
        inputEvents.add(new StreamRecord((Object)new Event(1, "dummy", 1111.0), 6L));
        inputEvents.add(new StreamRecord((Object)a3, 7L));
        inputEvents.add(new StreamRecord((Object)d, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d})}));
    }

    @Test
    public void testGreedyOneOrMoreWithDummyEventsAfterQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "dummy", 2.0), 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, d})}));
    }

    @Test
    public void testGreedyOneOrMoreWithDummyEventsBeforeQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event d = new Event(44, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "dummy", 2.0), 2L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList());
    }

    @Test
    public void testGreedyUntilOneOrMoreWithDummyEventsAfterQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 3.0);
        Event a3 = new Event(43, "a", 3.0);
        Event d = new Event(45, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)a3, 4L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "a", 4.0), 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().greedy().until((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getPrice() > 3.0)).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d})}));
    }

    @Test
    public void testGreedyUntilOneOrMoreWithDummyEventsBeforeQuantifier() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 3.0);
        Event a3 = new Event(43, "a", 3.0);
        Event d = new Event(45, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "a", 4.0), 2L));
        inputEvents.add(new StreamRecord((Object)a1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)a3, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().greedy().until((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getPrice() > 3.0)).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList());
    }

    @Test
    public void testGreedyZeroOrMoreBeforeGroupPattern() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(40, "a", 1.0);
        Event a2 = new Event(40, "a", 1.0);
        Event a3 = new Event(40, "a", 1.0);
        Event d1 = new Event(40, "d", 1.0);
        Event e1 = new Event(40, "e", 1.0);
        Event d2 = new Event(40, "d", 1.0);
        Event e2 = new Event(40, "e", 1.0);
        Event f = new Event(44, "f", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(43, "dummy", 2.0), 4L));
        inputEvents.add(new StreamRecord((Object)a3, 5L));
        inputEvents.add(new StreamRecord((Object)d1, 6L));
        inputEvents.add(new StreamRecord((Object)e1, 7L));
        inputEvents.add(new StreamRecord((Object)d2, 8L));
        inputEvents.add(new StreamRecord((Object)e2, 9L));
        inputEvents.add(new StreamRecord((Object)f, 10L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy().followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")))).times(2).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("f")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, d1, e1, d2, e2, f})}));
    }

    @Test
    public void testEndWithZeroOrMoreGreedy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "dummy", 2.0), 4L));
        inputEvents.add(new StreamRecord((Object)a3, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().greedy();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c}), Lists.newArrayList((Object[])new Event[]{c, a1}), Lists.newArrayList((Object[])new Event[]{c, a1, a2}), Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3})}));
    }

    @Test
    public void testEndWithZeroOrMoreConsecutiveGreedy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "dummy", 2.0), 4L));
        inputEvents.add(new StreamRecord((Object)a3, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().consecutive().greedy();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c}), Lists.newArrayList((Object[])new Event[]{c, a1}), Lists.newArrayList((Object[])new Event[]{c, a1, a2})}));
    }

    @Test
    public void testEndWithGreedyTimesRange() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        Event a4 = new Event(44, "a", 2.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)a3, 4L));
        inputEvents.add(new StreamRecord((Object)a4, 5L));
        inputEvents.add(new StreamRecord((Object)new Event(44, "dummy", 2.0), 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 5).greedy();
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2}), Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3}), Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, a4})}));
    }

    @Test
    public void testGreedyTimesRange() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event a3 = new Event(43, "a", 2.0);
        Event a4 = new Event(44, "a", 2.0);
        Event d = new Event(45, "d", 2.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)a3, 4L));
        inputEvents.add(new StreamRecord((Object)a4, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).times(2, 5).greedy().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, a2, a3, a4, d})}));
    }
}

