/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.NFAStateSerializer;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNodeSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class NFASerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    NFASerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("event-id-serializer", flinkVersion, EventIdSerializerSetup.class, EventIdSerializerVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("node-id-serializer", flinkVersion, NodeIdSerializerSetup.class, NodeIdSerializerVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("dewey-number-serializer", flinkVersion, DeweyNumberSerializerSetup.class, DeweyNumberSerializerVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("shared-buffer-edge-serializer", flinkVersion, SharedBufferEdgeSerializerSetup.class, SharedBufferEdgeSerializerVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("nfa-state-serializer", flinkVersion, NFAStateSerializerSetup.class, NFAStateSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class NFAStateSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<NFAState> {
        public TypeSerializer<NFAState> createUpgradedSerializer() {
            return new NFAStateSerializer();
        }

        public Matcher<NFAState> testDataMatcher() {
            return Matchers.is((Object)new NFAState(Collections.emptyList()));
        }

        public Matcher<TypeSerializerSchemaCompatibility<NFAState>> schemaCompatibilityMatcher(FlinkVersion version) {
            if (version.isNewerVersionThan(FlinkVersion.v1_15)) {
                return TypeSerializerMatchers.isCompatibleAsIs();
            }
            return TypeSerializerMatchers.isCompatibleAfterMigration();
        }
    }

    public static final class NFAStateSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<NFAState> {
        public TypeSerializer<NFAState> createPriorSerializer() {
            return new NFAStateSerializer();
        }

        public NFAState createTestData() {
            return new NFAState(Collections.emptyList());
        }
    }

    public static final class SharedBufferNodeSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<SharedBufferNode> {
        public TypeSerializer<SharedBufferNode> createUpgradedSerializer() {
            return new SharedBufferNodeSerializer();
        }

        public Matcher<SharedBufferNode> testDataMatcher() {
            SharedBufferNode result = new SharedBufferNode();
            result.addEdge(new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42)));
            return Matchers.is((Object)result);
        }

        public Matcher<TypeSerializerSchemaCompatibility<SharedBufferNode>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class SharedBufferNodeSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<SharedBufferNode> {
        public TypeSerializer<SharedBufferNode> createPriorSerializer() {
            return new SharedBufferNodeSerializer();
        }

        public SharedBufferNode createTestData() {
            SharedBufferNode result = new SharedBufferNode();
            result.addEdge(new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42)));
            return result;
        }
    }

    public static final class SharedBufferEdgeSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<SharedBufferEdge> {
        public TypeSerializer<SharedBufferEdge> createUpgradedSerializer() {
            return new SharedBufferEdge.SharedBufferEdgeSerializer();
        }

        public Matcher<SharedBufferEdge> testDataMatcher() {
            return Matchers.is((Object)new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42)));
        }

        public Matcher<TypeSerializerSchemaCompatibility<SharedBufferEdge>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class SharedBufferEdgeSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<SharedBufferEdge> {
        public TypeSerializer<SharedBufferEdge> createPriorSerializer() {
            return new SharedBufferEdge.SharedBufferEdgeSerializer();
        }

        public SharedBufferEdge createTestData() {
            return new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42));
        }
    }

    public static final class DeweyNumberSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<DeweyNumber> {
        public TypeSerializer<DeweyNumber> createUpgradedSerializer() {
            return DeweyNumber.DeweyNumberSerializer.INSTANCE;
        }

        public Matcher<DeweyNumber> testDataMatcher() {
            return Matchers.is((Object)new DeweyNumber(42));
        }

        public Matcher<TypeSerializerSchemaCompatibility<DeweyNumber>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class DeweyNumberSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<DeweyNumber> {
        public TypeSerializer<DeweyNumber> createPriorSerializer() {
            return DeweyNumber.DeweyNumberSerializer.INSTANCE;
        }

        public DeweyNumber createTestData() {
            return new DeweyNumber(42);
        }
    }

    public static final class NodeIdSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<NodeId> {
        public TypeSerializer<NodeId> createUpgradedSerializer() {
            return new NodeId.NodeIdSerializer();
        }

        public Matcher<NodeId> testDataMatcher() {
            return Matchers.is((Object)new NodeId(new EventId(42, 42L), "ciao"));
        }

        public Matcher<TypeSerializerSchemaCompatibility<NodeId>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class NodeIdSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<NodeId> {
        public TypeSerializer<NodeId> createPriorSerializer() {
            return new NodeId.NodeIdSerializer();
        }

        public NodeId createTestData() {
            return new NodeId(new EventId(42, 42L), "ciao");
        }
    }

    public static final class EventIdSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<EventId> {
        public TypeSerializer<EventId> createUpgradedSerializer() {
            return EventId.EventIdSerializer.INSTANCE;
        }

        public Matcher<EventId> testDataMatcher() {
            return Matchers.is((Object)new EventId(42, 42L));
        }

        public Matcher<TypeSerializerSchemaCompatibility<EventId>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class EventIdSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<EventId> {
        public TypeSerializer<EventId> createPriorSerializer() {
            return EventId.EventIdSerializer.INSTANCE;
        }

        public EventId createTestData() {
            return new EventId(42, 42L);
        }
    }
}

