/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform.exceptions;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.typeutils.BinaryRecordDataExtractor;

public class TransformException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String UNKNOWN_PLACEHOLDER = "(Unknown)";

    public TransformException(String command, Event event, @Nullable TableId tableId, @Nullable Schema schemaBefore, @Nullable Schema schemaAfter, Throwable cause) {
        super(String.format("Failed to %s with\n\t%s\nfor table\n\t%s\nfrom schema\n\t%s\nto schema\n\t%s.", command, TransformException.prettyPrintEvent(event, schemaBefore), Optional.ofNullable(tableId).map(Object::toString).orElse(UNKNOWN_PLACEHOLDER), Optional.ofNullable(schemaBefore).map(Object::toString).orElse(UNKNOWN_PLACEHOLDER), Optional.ofNullable(schemaAfter).map(Object::toString).orElse(UNKNOWN_PLACEHOLDER)), cause);
    }

    @VisibleForTesting
    public static String prettyPrintEvent(Event event, @Nullable Schema schema) {
        try {
            if (event instanceof DataChangeEvent && schema != null) {
                return ((DataChangeEvent)event).toReadableString(rec -> BinaryRecordDataExtractor.extractRecord(rec, schema));
            }
            return event.toString();
        }
        catch (Exception e) {
            return event.toString();
        }
    }

    public static String prettyPrintColumnNameMap(Map<String, String> columnNameMap) {
        return columnNameMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> Integer.parseInt(((String)entry.getValue()).substring(1)))).map(entry -> String.format("%s -> %s", entry.getValue(), entry.getKey())).collect(Collectors.joining(", "));
    }
}

