/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.cdc.runtime.typeutils.BinaryRecordDataGenerator;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;

public class PostTransformChangeInfo {
    private final TableId tableId;
    private final Schema preTransformedSchema;
    private final Schema postTransformedSchema;
    private final Map<String, Integer> preTransformedSchemaFieldNameToIndexMap;
    private final RecordData.FieldGetter[] preTransformedFieldGetters;
    private final RecordData.FieldGetter[] postTransformedFieldGetters;
    private final BinaryRecordDataGenerator postTransformedRecordDataGenerator;
    private final Map<String, Integer> postTransformedSchemaFieldNameToIndexMap;

    public static PostTransformChangeInfo of(TableId tableId, Schema preTransformedSchema, Schema postTransformedSchema) {
        List preTransformedFieldGetters = SchemaUtils.createFieldGetters((List)preTransformedSchema.getColumns());
        List postTransformedFieldGetters = SchemaUtils.createFieldGetters((List)postTransformedSchema.getColumns());
        BinaryRecordDataGenerator postTransformedRecordDataGenerator = new BinaryRecordDataGenerator(DataTypeConverter.toRowType(postTransformedSchema.getColumns()));
        return new PostTransformChangeInfo(tableId, preTransformedSchema, preTransformedFieldGetters.toArray(new RecordData.FieldGetter[0]), postTransformedSchema, postTransformedFieldGetters.toArray(new RecordData.FieldGetter[0]), postTransformedRecordDataGenerator);
    }

    private PostTransformChangeInfo(TableId tableId, Schema preTransformedSchema, RecordData.FieldGetter[] preTransformedFieldGetters, Schema postTransformedSchema, RecordData.FieldGetter[] postTransformedFieldGetters, BinaryRecordDataGenerator postTransformedRecordDataGenerator) {
        int i;
        this.tableId = tableId;
        this.preTransformedSchema = preTransformedSchema;
        this.preTransformedFieldGetters = preTransformedFieldGetters;
        this.preTransformedSchemaFieldNameToIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < preTransformedSchema.getColumns().size(); ++i) {
            this.preTransformedSchemaFieldNameToIndexMap.put(((Column)preTransformedSchema.getColumns().get(i)).getName(), i);
        }
        this.postTransformedSchema = postTransformedSchema;
        this.postTransformedFieldGetters = postTransformedFieldGetters;
        this.postTransformedRecordDataGenerator = postTransformedRecordDataGenerator;
        this.postTransformedSchemaFieldNameToIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < postTransformedSchema.getColumns().size(); ++i) {
            this.postTransformedSchemaFieldNameToIndexMap.put(((Column)postTransformedSchema.getColumns().get(i)).getName(), i);
        }
    }

    public String getName() {
        return this.tableId.identifier();
    }

    public String getTableName() {
        return this.tableId.getTableName();
    }

    public String getSchemaName() {
        return this.tableId.getSchemaName();
    }

    public String getNamespace() {
        return this.tableId.getNamespace();
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public Schema getPreTransformedSchema() {
        return this.preTransformedSchema;
    }

    public Schema getPostTransformedSchema() {
        return this.postTransformedSchema;
    }

    @Nullable
    public Integer getPreTransformedSchemaFieldIndex(String fieldName) {
        return this.preTransformedSchemaFieldNameToIndexMap.get(fieldName);
    }

    @Nullable
    public Integer getPostTransformedSchemaFieldIndex(String fieldName) {
        return this.postTransformedSchemaFieldNameToIndexMap.get(fieldName);
    }

    public RecordData.FieldGetter[] getPreTransformedFieldGetters() {
        return this.preTransformedFieldGetters;
    }

    public BinaryRecordDataGenerator getPostTransformedRecordDataGenerator() {
        return this.postTransformedRecordDataGenerator;
    }
}

