/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;

public final class StringSerializer
extends TypeSerializerSingleton<String> {
    private static final long serialVersionUID = 1L;
    public static final StringSerializer INSTANCE = new StringSerializer();
    private static final String EMPTY = "";

    public boolean isImmutableType() {
        return true;
    }

    public String createInstance() {
        return EMPTY;
    }

    public String copy(String from) {
        return from;
    }

    public String copy(String from, String reuse) {
        return from;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(String record, DataOutputView target) throws IOException {
        StringValue.writeString((CharSequence)record, (DataOutput)target);
    }

    public String deserialize(DataInputView source) throws IOException {
        return StringValue.readString((DataInput)source);
    }

    public String deserialize(String record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        StringValue.copyString((DataInput)source, (DataOutput)target);
    }

    public TypeSerializerSnapshot<String> snapshotConfiguration() {
        return new StringSerializerSnapshot();
    }

    public static final class StringSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<String> {
        public StringSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

