/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TransformExpressionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final List<String> argumentNames;
    private final List<Class<?>> argumentClasses;
    private final Class<?> returnClass;
    private final Map<String, String> columnNameMap;

    private TransformExpressionKey(String expression, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass, Map<String, String> columnNameMap) {
        this.expression = expression;
        this.argumentNames = argumentNames;
        this.argumentClasses = argumentClasses;
        this.returnClass = returnClass;
        this.columnNameMap = columnNameMap;
    }

    public String getExpression() {
        return this.expression;
    }

    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    public List<Class<?>> getArgumentClasses() {
        return this.argumentClasses;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public Map<String, String> getColumnNameMap() {
        return this.columnNameMap;
    }

    public static TransformExpressionKey of(String expression, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass, Map<String, String> columnNameMap) {
        return new TransformExpressionKey(expression, argumentNames, argumentClasses, returnClass, columnNameMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformExpressionKey that = (TransformExpressionKey)o;
        return this.expression.equals(that.expression) && this.argumentNames.equals(that.argumentNames) && this.argumentClasses.equals(that.argumentClasses) && this.returnClass.equals(that.returnClass) && this.columnNameMap.equals(that.columnNameMap);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.argumentNames, this.argumentClasses, this.returnClass, this.columnNameMap);
    }

    public String toString() {
        return "TransformExpressionKey{expression='" + this.expression + '\'' + ", argumentNames=" + this.argumentNames + ", argumentClasses=" + this.argumentClasses + ", returnClass=" + this.returnClass + ", columnNameMap=" + this.columnNameMap + '}';
    }
}

