/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.utils.StringUtils;

public class SchemaMetadataTransform
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> primaryKeys = new ArrayList<String>();
    private List<String> partitionKeys = new ArrayList<String>();
    private Map<String, String> options = new HashMap<String, String>();

    public SchemaMetadataTransform(String primaryKeyString, String partitionKeyString, String tableOptionString) {
        int i;
        if (!StringUtils.isNullOrWhitespaceOnly((String)primaryKeyString)) {
            String[] primaryKeyArr = primaryKeyString.split(",");
            for (i = 0; i < primaryKeyArr.length; ++i) {
                primaryKeyArr[i] = primaryKeyArr[i].trim();
            }
            this.primaryKeys = Arrays.asList(primaryKeyArr);
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)partitionKeyString)) {
            String[] partitionKeyArr = partitionKeyString.split(",");
            for (i = 0; i < partitionKeyArr.length; ++i) {
                partitionKeyArr[i] = partitionKeyArr[i].trim();
            }
            this.partitionKeys = Arrays.asList(partitionKeyArr);
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)tableOptionString)) {
            for (String tableOption : tableOptionString.split(",")) {
                String[] kv = tableOption.split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("table option format error: " + tableOptionString + ", it should be like `key1=value1,key2=value2`.");
                }
                this.options.put(kv[0].trim(), kv[1].trim());
            }
        }
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }
}

