/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.TransformContext;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionCompiler;
import org.apache.flink.cdc.runtime.operators.transform.TransformExpressionKey;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.MetadataColumns;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.codehaus.janino.ExpressionEvaluator;

public class ProjectionColumnProcessor {
    private final PostTransformChangeInfo tableInfo;
    private final ProjectionColumn projectionColumn;
    private final String timezone;
    private final TransformExpressionKey transformExpressionKey;
    private final Map<String, SupportedMetadataColumn> supportedMetadataColumns;
    private final List<Object> udfFunctionInstances;
    private final ExpressionEvaluator expressionEvaluator;

    public ProjectionColumnProcessor(PostTransformChangeInfo tableInfo, ProjectionColumn projectionColumn, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, Map<String, SupportedMetadataColumn> supportedMetadataColumns) {
        this.tableInfo = tableInfo;
        this.projectionColumn = projectionColumn;
        this.timezone = timezone;
        this.supportedMetadataColumns = supportedMetadataColumns;
        this.transformExpressionKey = this.generateTransformExpressionKey();
        this.expressionEvaluator = TransformExpressionCompiler.compileExpression(this.transformExpressionKey, udfDescriptors);
        this.udfFunctionInstances = udfFunctionInstances;
    }

    public static ProjectionColumnProcessor of(PostTransformChangeInfo tableInfo, ProjectionColumn projectionColumn, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, Map<String, SupportedMetadataColumn> supportedMetadataColumns) {
        return new ProjectionColumnProcessor(tableInfo, projectionColumn, timezone, udfDescriptors, udfFunctionInstances, supportedMetadataColumns);
    }

    public Object evaluate(Object[] rowData, TransformContext context) {
        try {
            Object[] params = this.generateParams(rowData, context);
            return this.expressionEvaluator.evaluate(params);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to evaluate projection expression `%s` for column `%s` in table `%s`.\n\tColumn name map: {%s}", this.projectionColumn.getScriptExpression(), this.projectionColumn.getColumnName(), this.tableInfo.getName(), this.projectionColumn.getColumnNameMapAsString()), e);
        }
    }

    private Object[] generateParams(Object[] rowData, TransformContext context) {
        ArrayList<Object> params = new ArrayList<Object>();
        LinkedHashSet<String> originalColumnNames = new LinkedHashSet<String>(this.projectionColumn.getOriginalColumnNames());
        for (String columnName : originalColumnNames) {
            params.add(TransformContext.lookupObjectByName(columnName, this.tableInfo, this.supportedMetadataColumns, rowData, null, context));
        }
        params.add(this.timezone);
        params.add(context.epochTime);
        params.addAll(this.udfFunctionInstances);
        return params.toArray();
    }

    private TransformExpressionKey generateTransformExpressionKey() {
        ArrayList<String> argumentNames = new ArrayList<String>();
        ArrayList paramTypes = new ArrayList();
        List columns = this.tableInfo.getPreTransformedSchema().getColumns();
        String scriptExpression = this.projectionColumn.getScriptExpression();
        Map<String, String> columnNameMap = this.projectionColumn.getColumnNameMap();
        LinkedHashSet<String> originalColumnNames = new LinkedHashSet<String>(this.projectionColumn.getOriginalColumnNames());
        for (String originalColumnName : originalColumnNames) {
            for (Column column : columns) {
                if (!column.getName().equals(originalColumnName)) continue;
                argumentNames.add(columnNameMap.get(originalColumnName));
                paramTypes.add(DataTypeConverter.convertOriginalClass(column.getType()));
                break;
            }
            MetadataColumns.METADATA_COLUMNS.stream().filter(col -> ((String)col.f0).equals(originalColumnName)).findFirst().ifPresent(col -> {
                argumentNames.add((String)columnNameMap.get(col.f0));
                paramTypes.add((Class<?>)col.f2);
            });
            this.supportedMetadataColumns.entrySet().stream().filter(col -> ((SupportedMetadataColumn)col.getValue()).getName().equals(originalColumnName)).findFirst().ifPresent(col -> {
                argumentNames.add((String)columnNameMap.get(((SupportedMetadataColumn)col.getValue()).getName()));
                paramTypes.add(((SupportedMetadataColumn)col.getValue()).getJavaClass());
            });
        }
        argumentNames.add("__time_zone__");
        paramTypes.add(String.class);
        argumentNames.add("__epoch_time__");
        paramTypes.add(Long.class);
        return TransformExpressionKey.of(JaninoCompiler.loadSystemFunction(scriptExpression), argumentNames, paramTypes, DataTypeConverter.convertOriginalClass(this.projectionColumn.getDataType()), columnNameMap);
    }
}

