/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.sink;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.ChangeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.FlushEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.operators.sink.SchemaEvolutionClient;
import org.apache.flink.cdc.runtime.operators.sink.exception.SinkWrapperException;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public class DataSinkFunctionOperator
extends StreamSink<Event> {
    private SchemaEvolutionClient schemaEvolutionClient;
    private final OperatorID schemaOperatorID;
    private final Set<TableId> processedTableIds;

    public DataSinkFunctionOperator(SinkFunction<Event> userFunction, OperatorID schemaOperatorID) {
        super(userFunction);
        this.schemaOperatorID = schemaOperatorID;
        this.processedTableIds = new HashSet<TableId>();
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<Object>> output) {
        super.setup(containingTask, config, output);
        this.schemaEvolutionClient = new SchemaEvolutionClient(containingTask.getEnvironment().getOperatorCoordinatorEventGateway(), this.schemaOperatorID);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        this.schemaEvolutionClient.registerSubtask(this.getRuntimeContext().getIndexOfThisSubtask());
        super.initializeState(context);
    }

    public void processElement(StreamRecord<Event> element) throws Exception {
        Event event = (Event)element.getValue();
        try {
            if (event instanceof FlushEvent) {
                this.handleFlushEvent((FlushEvent)event);
                return;
            }
            if (event instanceof CreateTableEvent) {
                this.processedTableIds.add(((CreateTableEvent)event).tableId());
                super.processElement(element);
                return;
            }
            ChangeEvent changeEvent = (ChangeEvent)event;
            if (!this.processedTableIds.contains(changeEvent.tableId())) {
                this.emitLatestSchema(changeEvent.tableId());
                this.processedTableIds.add(changeEvent.tableId());
            }
            this.processedTableIds.add(changeEvent.tableId());
            super.processElement(element);
        }
        catch (Exception e) {
            throw new SinkWrapperException(event, (Throwable)e);
        }
    }

    private void handleFlushEvent(FlushEvent event) throws Exception {
        ((SinkFunction)this.userFunction).finish();
        if (event.getSchemaChangeEventType() != SchemaChangeEventType.CREATE_TABLE) {
            event.getTableIds().stream().filter(tableId -> !this.processedTableIds.contains(tableId)).forEach(tableId -> {
                LOG.info("Table {} has not been processed", tableId);
                try {
                    this.emitLatestSchema((TableId)tableId);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.processedTableIds.add((TableId)tableId);
            });
        }
        this.schemaEvolutionClient.notifyFlushSuccess(this.getRuntimeContext().getIndexOfThisSubtask(), event.getSourceSubTaskId());
    }

    private void emitLatestSchema(TableId tableId) throws Exception {
        Optional<Schema> schema = this.schemaEvolutionClient.getLatestEvolvedSchema(tableId);
        if (!schema.isPresent()) {
            throw new RuntimeException("Could not find schema message from SchemaRegistry for " + tableId);
        }
        super.processElement(new StreamRecord((Object)new CreateTableEvent(tableId, schema.get())));
        this.processedTableIds.add(tableId);
    }
}

