/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.pipeline.SchemaChangeBehavior;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.cdc.runtime.serializer.schema.SchemaSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

@Internal
public class SchemaManager {
    private static final int INITIAL_SCHEMA_VERSION = 0;
    private static final int VERSIONS_TO_KEEP = 3;
    private final SchemaChangeBehavior behavior;
    public static final Serializer SERIALIZER = new Serializer();
    private final Map<TableId, SortedMap<Integer, Schema>> originalSchemas;
    private final Map<TableId, SortedMap<Integer, Schema>> evolvedSchemas;

    public SchemaManager() {
        this(new ConcurrentHashMap<TableId, SortedMap<Integer, Schema>>(), new ConcurrentHashMap<TableId, SortedMap<Integer, Schema>>(), SchemaChangeBehavior.EVOLVE);
    }

    public SchemaManager(SchemaChangeBehavior schemaChangeBehavior) {
        this(new ConcurrentHashMap<TableId, SortedMap<Integer, Schema>>(), new ConcurrentHashMap<TableId, SortedMap<Integer, Schema>>(), schemaChangeBehavior);
    }

    public SchemaManager(Map<TableId, SortedMap<Integer, Schema>> originalSchemas, Map<TableId, SortedMap<Integer, Schema>> evolvedSchemas, SchemaChangeBehavior behavior) {
        this.evolvedSchemas = new ConcurrentHashMap<TableId, SortedMap<Integer, Schema>>(evolvedSchemas);
        this.originalSchemas = new ConcurrentHashMap<TableId, SortedMap<Integer, Schema>>(originalSchemas);
        this.behavior = behavior;
    }

    public SchemaChangeBehavior getBehavior() {
        return this.behavior;
    }

    public final boolean schemaExists(Map<TableId, SortedMap<Integer, Schema>> schemaMap, TableId tableId) {
        return schemaMap.containsKey(tableId) && !schemaMap.get(tableId).isEmpty();
    }

    public final boolean originalSchemaExists(TableId tableId) {
        return this.schemaExists(this.originalSchemas, tableId);
    }

    public final boolean evolvedSchemaExists(TableId tableId) {
        return this.schemaExists(this.evolvedSchemas, tableId);
    }

    public final Set<TableId> getAllOriginalTables() {
        return this.originalSchemas.keySet();
    }

    public Optional<Schema> getLatestEvolvedSchema(TableId tableId) {
        return this.getLatestSchemaVersion(this.evolvedSchemas, tableId).map(version -> (Schema)this.evolvedSchemas.get(tableId).get(version));
    }

    public Optional<Schema> getLatestOriginalSchema(TableId tableId) {
        return this.getLatestSchemaVersion(this.originalSchemas, tableId).map(version -> (Schema)this.originalSchemas.get(tableId).get(version));
    }

    public Schema getEvolvedSchema(TableId tableId, int version) {
        Preconditions.checkArgument((boolean)this.evolvedSchemas.containsKey(tableId), (String)"Unable to find evolved schema for table \"%s\"", (Object[])new Object[]{tableId});
        SortedMap<Integer, Schema> versionedSchemas = this.evolvedSchemas.get(tableId);
        Preconditions.checkArgument((boolean)versionedSchemas.containsKey(version), (String)"Schema version %s does not exist for table \"%s\"", (Object[])new Object[]{version, tableId});
        return (Schema)versionedSchemas.get(version);
    }

    public Schema getOriginalSchema(TableId tableId, int version) {
        Preconditions.checkArgument((boolean)this.originalSchemas.containsKey(tableId), (String)"Unable to find original schema for table \"%s\"", (Object[])new Object[]{tableId});
        SortedMap<Integer, Schema> versionedSchemas = this.originalSchemas.get(tableId);
        Preconditions.checkArgument((boolean)versionedSchemas.containsKey(version), (String)"Schema version %s does not exist for table \"%s\"", (Object[])new Object[]{version, tableId});
        return (Schema)versionedSchemas.get(version);
    }

    public void applyOriginalSchemaChange(SchemaChangeEvent schemaChangeEvent) {
        if (schemaChangeEvent instanceof CreateTableEvent) {
            this.handleCreateTableEvent(this.originalSchemas, (CreateTableEvent)schemaChangeEvent);
        } else {
            Optional<Schema> optionalSchema = this.getLatestOriginalSchema(schemaChangeEvent.tableId());
            Preconditions.checkArgument((boolean)optionalSchema.isPresent(), (String)"Unable to apply SchemaChangeEvent for table \"%s\" without existing schema", (Object[])new Object[]{schemaChangeEvent.tableId()});
            this.registerNewSchema(this.originalSchemas, schemaChangeEvent.tableId(), SchemaUtils.applySchemaChangeEvent((Schema)optionalSchema.get(), (SchemaChangeEvent)schemaChangeEvent));
        }
    }

    public void applyEvolvedSchemaChange(SchemaChangeEvent schemaChangeEvent) {
        if (schemaChangeEvent instanceof CreateTableEvent) {
            this.handleCreateTableEvent(this.evolvedSchemas, (CreateTableEvent)schemaChangeEvent);
        } else {
            Optional<Schema> optionalSchema = this.getLatestEvolvedSchema(schemaChangeEvent.tableId());
            Preconditions.checkArgument((boolean)optionalSchema.isPresent(), (String)"Unable to apply SchemaChangeEvent for table \"%s\" without existing schema", (Object[])new Object[]{schemaChangeEvent.tableId()});
            this.registerNewSchema(this.evolvedSchemas, schemaChangeEvent.tableId(), SchemaUtils.applySchemaChangeEvent((Schema)optionalSchema.get(), (SchemaChangeEvent)schemaChangeEvent));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaManager that = (SchemaManager)o;
        return Objects.equals(this.originalSchemas, that.originalSchemas) && Objects.equals(this.evolvedSchemas, that.evolvedSchemas);
    }

    public int hashCode() {
        return Objects.hash(this.originalSchemas, this.evolvedSchemas);
    }

    private Optional<Integer> getLatestSchemaVersion(Map<TableId, SortedMap<Integer, Schema>> schemaMap, TableId tableId) {
        if (!schemaMap.containsKey(tableId)) {
            return Optional.empty();
        }
        try {
            return Optional.of(schemaMap.get(tableId).lastKey());
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    private void handleCreateTableEvent(Map<TableId, SortedMap<Integer, Schema>> schemaMap, CreateTableEvent event) {
        this.registerNewSchema(schemaMap, event.tableId(), event.getSchema());
    }

    private void registerNewSchema(Map<TableId, SortedMap<Integer, Schema>> schemaMap, TableId tableId, Schema newSchema) {
        if (this.schemaExists(schemaMap, tableId)) {
            SortedMap<Integer, Schema> versionedSchemas = schemaMap.get(tableId);
            Integer latestVersion = versionedSchemas.lastKey();
            versionedSchemas.put(latestVersion + 1, newSchema);
            if (versionedSchemas.size() > 3) {
                versionedSchemas.remove(versionedSchemas.firstKey());
            }
        } else {
            TreeMap<Integer, Schema> versionedSchemas = new TreeMap<Integer, Schema>();
            versionedSchemas.put(0, newSchema);
            schemaMap.putIfAbsent(tableId, versionedSchemas);
        }
    }

    @VisibleForTesting
    public void registerNewOriginalSchema(TableId tableId, Schema newSchema) {
        this.registerNewSchema(this.originalSchemas, tableId, newSchema);
    }

    @VisibleForTesting
    public void registerNewEvolvedSchema(TableId tableId, Schema newSchema) {
        this.registerNewSchema(this.evolvedSchemas, tableId, newSchema);
    }

    public String toString() {
        return String.format("Schema Manager %s: \n\toriginal schema map:\n%s\n\tevolved schema map:\n%s", this.hashCode(), SchemaManager.schemaMapToString(this.originalSchemas), SchemaManager.schemaMapToString(this.evolvedSchemas));
    }

    private static String schemaMapToString(Map<TableId, SortedMap<Integer, Schema>> schemaMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TableId, SortedMap<Integer, Schema>> entry : schemaMap.entrySet()) {
            TableId tableId = entry.getKey();
            SortedMap<Integer, Schema> versionedSchemas = entry.getValue();
            sb.append(String.format("\t\t- table %s: %s\n", tableId, schemaMap));
        }
        return sb.toString();
    }

    static /* synthetic */ Map access$000(SchemaManager x0) {
        return x0.evolvedSchemas;
    }

    static /* synthetic */ Map access$100(SchemaManager x0) {
        return x0.originalSchemas;
    }

    public static class Serializer
    implements SimpleVersionedSerializer<SchemaManager> {
        public static final int CURRENT_VERSION = 2;

        public int getVersion() {
            return 2;
        }

        /*
         * Exception decompiling
         */
        public byte[] serialize(SchemaManager schemaManager) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static void serializeSchemaMap(Map<TableId, SortedMap<Integer, Schema>> schemaMap, DataOutputStream out) throws IOException {
            TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
            SchemaSerializer schemaSerializer = SchemaSerializer.INSTANCE;
            out.writeInt(schemaMap.size());
            for (Map.Entry<TableId, SortedMap<Integer, Schema>> tableSchema : schemaMap.entrySet()) {
                TableId tableId = tableSchema.getKey();
                tableIdSerializer.serialize(tableId, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
                SortedMap<Integer, Schema> versionedSchemas = tableSchema.getValue();
                out.writeInt(versionedSchemas.size());
                for (Map.Entry<Integer, Schema> versionedSchema : versionedSchemas.entrySet()) {
                    Integer version = versionedSchema.getKey();
                    out.writeInt(version);
                    Schema schema = versionedSchema.getValue();
                    schemaSerializer.serialize(schema, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
                }
            }
        }

        /*
         * Exception decompiling
         */
        public SchemaManager deserialize(int version, byte[] serialized) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static Map<TableId, SortedMap<Integer, Schema>> deserializeSchemaMap(int version, DataInputStream in) throws IOException {
            TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
            SchemaSerializer schemaSerializer = SchemaSerializer.INSTANCE;
            int numTables = in.readInt();
            HashMap<TableId, SortedMap<Integer, Schema>> tableSchemas = new HashMap<TableId, SortedMap<Integer, Schema>>(numTables);
            for (int i = 0; i < numTables; ++i) {
                TableId tableId = tableIdSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
                int numVersions = in.readInt();
                TreeMap<Integer, Schema> versionedSchemas = new TreeMap<Integer, Schema>(Integer::compareTo);
                for (int j = 0; j < numVersions; ++j) {
                    int schemaVersion = in.readInt();
                    Schema schema = schemaSerializer.deserialize(version, (DataInputView)new DataInputViewStreamWrapper((InputStream)in));
                    versionedSchemas.put(schemaVersion, schema);
                }
                tableSchemas.put(tableId, versionedSchemas);
            }
            return tableSchemas;
        }
    }
}

