/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.typeutils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.GenericArrayData;
import org.apache.flink.cdc.common.data.GenericMapData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.data.binary.BinaryStringData;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.ArrayType;
import org.apache.flink.cdc.common.types.BigIntType;
import org.apache.flink.cdc.common.types.BinaryType;
import org.apache.flink.cdc.common.types.BooleanType;
import org.apache.flink.cdc.common.types.CharType;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.DateType;
import org.apache.flink.cdc.common.types.DecimalType;
import org.apache.flink.cdc.common.types.DoubleType;
import org.apache.flink.cdc.common.types.FloatType;
import org.apache.flink.cdc.common.types.IntType;
import org.apache.flink.cdc.common.types.LocalZonedTimestampType;
import org.apache.flink.cdc.common.types.MapType;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.types.SmallIntType;
import org.apache.flink.cdc.common.types.TimeType;
import org.apache.flink.cdc.common.types.TimestampType;
import org.apache.flink.cdc.common.types.TinyIntType;
import org.apache.flink.cdc.common.types.VarBinaryType;
import org.apache.flink.cdc.common.types.VarCharType;
import org.apache.flink.cdc.common.types.ZonedTimestampType;

public class DataTypeConverter {
    static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_DAY = TimeUnit.DAYS.toNanos(1L);

    public static RowType toRowType(List<Column> columnList) {
        DataType[] dataTypes = (DataType[])columnList.stream().map(Column::getType).toArray(DataType[]::new);
        String[] columnNames = (String[])columnList.stream().map(Column::getName).toArray(String[]::new);
        return RowType.of((DataType[])dataTypes, (String[])columnNames);
    }

    public static Class<?> convertOriginalClass(DataType dataType) {
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case DATE: {
                return Integer.class;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return Integer.class;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.class;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return ZonedTimestampData.class;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return LocalZonedTimestampData.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case CHAR: 
            case VARCHAR: {
                return String.class;
            }
            case BINARY: 
            case VARBINARY: {
                return byte[].class;
            }
            case DECIMAL: {
                return DecimalData.class;
            }
            case ROW: {
                return Object.class;
            }
            case ARRAY: {
                return ArrayData.class;
            }
            case MAP: {
                return MapData.class;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    public static RelDataType convertCalciteRelDataType(RelDataTypeFactory typeFactory, List<Column> columns) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        block22: for (Column column : columns) {
            switch (column.getType().getTypeRoot()) {
                case BOOLEAN: {
                    BooleanType booleanType = (BooleanType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.BOOLEAN).nullable(booleanType.isNullable());
                    continue block22;
                }
                case TINYINT: {
                    TinyIntType tinyIntType = (TinyIntType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.TINYINT).nullable(tinyIntType.isNullable());
                    continue block22;
                }
                case SMALLINT: {
                    SmallIntType smallIntType = (SmallIntType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.SMALLINT).nullable(smallIntType.isNullable());
                    continue block22;
                }
                case INTEGER: {
                    IntType intType = (IntType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.INTEGER).nullable(intType.isNullable());
                    continue block22;
                }
                case BIGINT: {
                    BigIntType bigIntType = (BigIntType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.BIGINT).nullable(bigIntType.isNullable());
                    continue block22;
                }
                case DATE: {
                    DateType dataType = (DateType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.DATE).nullable(dataType.isNullable());
                    continue block22;
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    TimeType timeType = (TimeType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, timeType.getPrecision()).nullable(timeType.isNullable());
                    continue block22;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    TimestampType timestampType = (TimestampType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.TIMESTAMP, timestampType.getPrecision()).nullable(timestampType.isNullable());
                    continue block22;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    ZonedTimestampType zonedTimestampType = (ZonedTimestampType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.TIMESTAMP, zonedTimestampType.getPrecision()).nullable(zonedTimestampType.isNullable());
                    continue block22;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, localZonedTimestampType.getPrecision()).nullable(localZonedTimestampType.isNullable());
                    continue block22;
                }
                case FLOAT: {
                    FloatType floatType = (FloatType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.FLOAT).nullable(floatType.isNullable());
                    continue block22;
                }
                case DOUBLE: {
                    DoubleType doubleType = (DoubleType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.DOUBLE).nullable(doubleType.isNullable());
                    continue block22;
                }
                case CHAR: {
                    CharType charType = (CharType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.CHAR, charType.getLength()).nullable(charType.isNullable());
                    continue block22;
                }
                case VARCHAR: {
                    VarCharType varCharType = (VarCharType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.VARCHAR, varCharType.getLength()).nullable(varCharType.isNullable());
                    continue block22;
                }
                case BINARY: {
                    BinaryType binaryType = (BinaryType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.BINARY, binaryType.getLength()).nullable(binaryType.isNullable());
                    continue block22;
                }
                case VARBINARY: {
                    VarBinaryType varBinaryType = (VarBinaryType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.VARBINARY, varBinaryType.getLength()).nullable(varBinaryType.isNullable());
                    continue block22;
                }
                case DECIMAL: {
                    DecimalType decimalType = (DecimalType)column.getType();
                    fieldInfoBuilder.add(column.getName(), SqlTypeName.DECIMAL, decimalType.getPrecision(), decimalType.getScale()).nullable(decimalType.isNullable());
                    continue block22;
                }
                case ROW: {
                    List dataTypes = ((RowType)column.getType()).getFieldTypes().stream().map(type -> DataTypeConverter.convertCalciteType(typeFactory, type)).collect(Collectors.toList());
                    fieldInfoBuilder.add(column.getName(), typeFactory.createStructType(dataTypes, ((RowType)column.getType()).getFieldNames())).nullable(true);
                    continue block22;
                }
                case ARRAY: {
                    DataType elementType = ((ArrayType)column.getType()).getElementType();
                    fieldInfoBuilder.add(column.getName(), typeFactory.createArrayType(DataTypeConverter.convertCalciteType(typeFactory, elementType), -1L)).nullable(true);
                    continue block22;
                }
                case MAP: {
                    RelDataType keyType = DataTypeConverter.convertCalciteType(typeFactory, ((MapType)column.getType()).getKeyType());
                    RelDataType valueType = DataTypeConverter.convertCalciteType(typeFactory, ((MapType)column.getType()).getValueType());
                    fieldInfoBuilder.add(column.getName(), typeFactory.createMapType(keyType, valueType)).nullable(true);
                    continue block22;
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + column.getType());
        }
        return fieldInfoBuilder.build();
    }

    public static RelDataType convertCalciteType(RelDataTypeFactory typeFactory, DataType dataType) {
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case TINYINT: {
                return typeFactory.createSqlType(SqlTypeName.TINYINT);
            }
            case SMALLINT: {
                return typeFactory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INTEGER: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case BIGINT: {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case DATE: {
                return typeFactory.createSqlType(SqlTypeName.DATE);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                TimeType timeType = (TimeType)dataType;
                return typeFactory.createSqlType(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, timeType.getPrecision());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)dataType;
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP, timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException("Unsupported type: TIMESTAMP_TZ");
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)dataType;
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, localZonedTimestampType.getPrecision());
            }
            case FLOAT: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case CHAR: {
                CharType charType = (CharType)dataType;
                return typeFactory.createSqlType(SqlTypeName.CHAR, charType.getLength());
            }
            case VARCHAR: {
                VarCharType varCharType = (VarCharType)dataType;
                return typeFactory.createSqlType(SqlTypeName.VARCHAR, varCharType.getLength());
            }
            case BINARY: {
                BinaryType binaryType = (BinaryType)dataType;
                return typeFactory.createSqlType(SqlTypeName.BINARY, binaryType.getLength());
            }
            case VARBINARY: {
                VarBinaryType varBinaryType = (VarBinaryType)dataType;
                return typeFactory.createSqlType(SqlTypeName.VARBINARY, varBinaryType.getLength());
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                return typeFactory.createSqlType(SqlTypeName.DECIMAL, decimalType.getPrecision(), decimalType.getScale());
            }
            case ROW: {
                List dataTypes = ((RowType)dataType).getFieldTypes().stream().map(type -> DataTypeConverter.convertCalciteType(typeFactory, type)).collect(Collectors.toList());
                return typeFactory.createStructType(dataTypes, ((RowType)dataType).getFieldNames());
            }
            case ARRAY: {
                DataType elementType = ((ArrayType)dataType).getElementType();
                return typeFactory.createArrayType(DataTypeConverter.convertCalciteType(typeFactory, elementType), -1L);
            }
            case MAP: {
                RelDataType keyType = DataTypeConverter.convertCalciteType(typeFactory, ((MapType)dataType).getKeyType());
                RelDataType valueType = DataTypeConverter.convertCalciteType(typeFactory, ((MapType)dataType).getValueType());
                return typeFactory.createMapType(keyType, valueType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    public static DataType convertCalciteRelDataTypeToDataType(RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case TINYINT: {
                return DataTypes.TINYINT();
            }
            case SMALLINT: {
                return DataTypes.SMALLINT();
            }
            case INTEGER: {
                return DataTypes.INT();
            }
            case BIGINT: {
                return DataTypes.BIGINT();
            }
            case DATE: {
                return DataTypes.DATE();
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return DataTypes.TIME((int)relDataType.getPrecision());
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP((int)relDataType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypes.TIMESTAMP_LTZ((int)relDataType.getPrecision());
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case CHAR: 
            case VARCHAR: {
                return DataTypes.STRING();
            }
            case BINARY: {
                return DataTypes.BINARY((int)relDataType.getPrecision());
            }
            case VARBINARY: {
                return DataTypes.VARBINARY((int)relDataType.getPrecision());
            }
            case DECIMAL: {
                return DataTypes.DECIMAL((int)relDataType.getPrecision(), (int)relDataType.getScale());
            }
            case ARRAY: {
                RelDataType componentType = relDataType.getComponentType();
                return DataTypes.ARRAY((DataType)DataTypeConverter.convertCalciteRelDataTypeToDataType(componentType));
            }
            case MAP: {
                RelDataType keyType = relDataType.getKeyType();
                RelDataType valueType = relDataType.getValueType();
                return DataTypes.MAP((DataType)DataTypeConverter.convertCalciteRelDataTypeToDataType(keyType), (DataType)DataTypeConverter.convertCalciteRelDataTypeToDataType(valueType));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + relDataType.getSqlTypeName());
    }

    public static Object convert(Object value, DataType dataType) {
        if (value == null) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return DataTypeConverter.convertToBoolean(value);
            }
            case TINYINT: {
                return DataTypeConverter.convertToByte(value);
            }
            case SMALLINT: {
                return DataTypeConverter.convertToShort(value);
            }
            case INTEGER: {
                return DataTypeConverter.convertToInt(value);
            }
            case BIGINT: {
                return DataTypeConverter.convertToLong(value);
            }
            case DATE: {
                return DataTypeConverter.convertToDate(value);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTime(value);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTimestamp(value);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return DataTypeConverter.convertToZonedTimestampData(value);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypeConverter.convertToLocalTimeZoneTimestamp(value);
            }
            case FLOAT: {
                return DataTypeConverter.convertToFloat(value);
            }
            case DOUBLE: {
                return DataTypeConverter.convertToDouble(value);
            }
            case CHAR: 
            case VARCHAR: {
                return DataTypeConverter.convertToString(value);
            }
            case BINARY: 
            case VARBINARY: {
                return DataTypeConverter.convertToBinary(value);
            }
            case DECIMAL: {
                return DataTypeConverter.convertToDecimal(value);
            }
            case ROW: {
                return value;
            }
            case ARRAY: {
                return DataTypeConverter.convertToArray(value, (ArrayType)dataType);
            }
            case MAP: {
                return DataTypeConverter.convertToMap(value, (MapType)dataType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    public static Object convertToOriginal(Object value, DataType dataType) {
        if (value == null) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: {
                return DataTypeConverter.convertToBoolean(value);
            }
            case TINYINT: {
                return DataTypeConverter.convertToByte(value);
            }
            case SMALLINT: {
                return DataTypeConverter.convertToShort(value);
            }
            case INTEGER: {
                return DataTypeConverter.convertToInt(value);
            }
            case BIGINT: {
                return DataTypeConverter.convertToLong(value);
            }
            case DATE: {
                return DataTypeConverter.convertToDate(value);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTime(value);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return DataTypeConverter.convertToTimestamp(value);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return DataTypeConverter.convertToZonedTimestampData(value);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypeConverter.convertToLocalTimeZoneTimestamp(value);
            }
            case FLOAT: {
                return DataTypeConverter.convertToFloat(value);
            }
            case DOUBLE: {
                return DataTypeConverter.convertToDouble(value);
            }
            case CHAR: 
            case VARCHAR: {
                return DataTypeConverter.convertToStringOriginal(value);
            }
            case BINARY: 
            case VARBINARY: {
                return DataTypeConverter.convertToBinary(value);
            }
            case DECIMAL: {
                return DataTypeConverter.convertToDecimal(value);
            }
            case ROW: {
                return value;
            }
            case ARRAY: {
                return DataTypeConverter.convertToArrayOriginal(value, (ArrayType)dataType);
            }
            case MAP: {
                return DataTypeConverter.convertToMapOriginal(value, (MapType)dataType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    private static Object convertToBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof Byte) {
            return (Byte)obj == 1;
        }
        if (obj instanceof Short) {
            return (Short)obj == 1;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private static Object convertToByte(Object obj) {
        return Byte.parseByte(obj.toString());
    }

    private static Object convertToShort(Object obj) {
        return Short.parseShort(obj.toString());
    }

    private static Object convertToInt(Object obj) {
        if (obj instanceof Integer) {
            return obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        return Integer.parseInt(obj.toString());
    }

    private static Object convertToLong(Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return obj;
        }
        return Long.parseLong(obj.toString());
    }

    private static Object convertToFloat(Object obj) {
        if (obj instanceof Float) {
            return obj;
        }
        if (obj instanceof Double) {
            return Float.valueOf(((Double)obj).floatValue());
        }
        return Float.valueOf(Float.parseFloat(obj.toString()));
    }

    private static Object convertToDouble(Object obj) {
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof Double) {
            return obj;
        }
        return Double.parseDouble(obj.toString());
    }

    private static Object convertToDate(Object obj) {
        return (int)DataTypeConverter.toLocalDate(obj).toEpochDay();
    }

    private static LocalDate toLocalDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDate) {
            return (LocalDate)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalDate();
        }
        if (obj instanceof Date) {
            return ((Date)obj).toLocalDate();
        }
        if (obj instanceof Time) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Time value '" + obj + "'");
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            return LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        }
        if (obj instanceof Long) {
            return LocalDate.ofEpochDay((Long)obj);
        }
        if (obj instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)obj).intValue());
        }
        throw new IllegalArgumentException("Unable to convert to LocalDate from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToTime(Object obj) {
        if (obj instanceof Integer) {
            return obj;
        }
        return DataTypeConverter.toLocalTime(obj).toSecondOfDay() * 1000;
    }

    private static Object convertToArray(Object obj, ArrayType arrayType) {
        if (obj instanceof ArrayData) {
            return obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            GenericArrayData arrayData = new GenericArrayData(list.toArray());
            return arrayData;
        }
        if (obj.getClass().isArray()) {
            return new GenericArrayData((Object[])obj);
        }
        throw new IllegalArgumentException("Unable to convert to ArrayData: " + obj);
    }

    private static Object convertToArrayOriginal(Object obj, ArrayType arrayType) {
        if (obj instanceof ArrayData) {
            ArrayData arrayData = (ArrayData)obj;
            Object[] result = new Object[arrayData.size()];
            for (int i = 0; i < arrayData.size(); ++i) {
                result[i] = DataTypeConverter.getArrayElement(arrayData, i, arrayType.getElementType());
            }
            return result;
        }
        return obj;
    }

    private static Object getArrayElement(ArrayData arrayData, int pos, DataType elementType) {
        switch (elementType.getTypeRoot()) {
            case BOOLEAN: {
                return arrayData.getBoolean(pos);
            }
            case TINYINT: {
                return arrayData.getByte(pos);
            }
            case SMALLINT: {
                return arrayData.getShort(pos);
            }
            case INTEGER: {
                return arrayData.getInt(pos);
            }
            case BIGINT: {
                return arrayData.getLong(pos);
            }
            case FLOAT: {
                return Float.valueOf(arrayData.getFloat(pos));
            }
            case DOUBLE: {
                return arrayData.getDouble(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return arrayData.getString(pos);
            }
            case DECIMAL: {
                return arrayData.getDecimal(pos, ((DecimalType)elementType).getPrecision(), ((DecimalType)elementType).getScale());
            }
            case DATE: {
                return arrayData.getInt(pos);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return arrayData.getInt(pos);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return arrayData.getTimestamp(pos, ((TimestampType)elementType).getPrecision());
            }
            case ARRAY: {
                return DataTypeConverter.convertToArrayOriginal(arrayData.getArray(pos), (ArrayType)elementType);
            }
            case MAP: {
                return DataTypeConverter.convertToMapOriginal(arrayData.getMap(pos), (MapType)elementType);
            }
        }
        throw new UnsupportedOperationException("Unsupported array element type: " + elementType);
    }

    private static Object convertToMap(Object obj, MapType mapType) {
        if (obj instanceof MapData) {
            return obj;
        }
        if (obj instanceof Map) {
            Map javaMap = (Map)obj;
            GenericMapData mapData = new GenericMapData(javaMap);
            return mapData;
        }
        throw new IllegalArgumentException("Unable to convert to MapData: " + obj);
    }

    private static Object convertToMapOriginal(Object obj, MapType mapType) {
        if (obj instanceof MapData) {
            MapData mapData = (MapData)obj;
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            ArrayData keyArray = mapData.keyArray();
            ArrayData valueArray = mapData.valueArray();
            for (int i = 0; i < mapData.size(); ++i) {
                Object key = DataTypeConverter.getArrayElement(keyArray, i, mapType.getKeyType());
                Object value = DataTypeConverter.getArrayElement(valueArray, i, mapType.getValueType());
                result.put(key, value);
            }
            return result;
        }
        return obj;
    }

    private static LocalTime toLocalTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalTime) {
            return (LocalTime)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalTime();
        }
        if (obj instanceof Date) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Date value '" + obj + "'");
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            long millis = (int)(time.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return LocalTime.of(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            long millis = (int)(date.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Duration) {
            Long value = ((Duration)obj).toNanos();
            if (value >= 0L && value <= NANOSECONDS_PER_DAY) {
                return LocalTime.ofNanoOfDay(value);
            }
            throw new IllegalArgumentException("Time values must use number of milliseconds greater than 0 and less than 86400000000000");
        }
        throw new IllegalArgumentException("Unable to convert to LocalTime from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToTimestamp(Object obj) {
        if (obj instanceof Long) {
            return TimestampData.fromMillis((long)((Long)obj));
        }
        if (obj instanceof Timestamp) {
            return TimestampData.fromTimestamp((Timestamp)((Timestamp)obj));
        }
        if (obj instanceof TimestampData) {
            return obj;
        }
        throw new IllegalArgumentException("Unable to convert to TIMESTAMP from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToZonedTimestampData(Object obj) {
        if (obj instanceof ZonedTimestampData) {
            return obj;
        }
        throw new IllegalArgumentException("Unable to convert to TIMESTAMP_TZ from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToLocalTimeZoneTimestamp(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            Instant instant = Instant.parse(str);
            return LocalZonedTimestampData.fromInstant((Instant)instant);
        }
        if (obj instanceof Long) {
            return LocalZonedTimestampData.fromEpochMillis((long)((Long)obj));
        }
        if (obj instanceof LocalZonedTimestampData) {
            return obj;
        }
        throw new IllegalArgumentException("Unable to convert to TIMESTAMP_LTZ from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    private static Object convertToString(Object obj) {
        return BinaryStringData.fromString((String)obj.toString());
    }

    private static Object convertToStringOriginal(Object obj) {
        return String.valueOf(obj);
    }

    private static Object convertToBinary(Object obj) {
        if (obj instanceof byte[]) {
            return obj;
        }
        if (obj instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)obj;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        throw new UnsupportedOperationException("Unsupported BYTES value type: " + obj.getClass().getSimpleName());
    }

    private static Object convertToDecimal(Object obj) {
        if (obj instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)obj;
            return DecimalData.fromBigDecimal((BigDecimal)bigDecimalValue, (int)bigDecimalValue.precision(), (int)bigDecimalValue.scale());
        }
        if (obj instanceof DecimalData) {
            return obj;
        }
        throw new UnsupportedOperationException("Unsupported Decimal value type: " + obj.getClass().getSimpleName());
    }
}

