/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.functions;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.flink.annotation.Internal;
import org.apache.flink.cdc.common.utils.Preconditions;

@Internal
public class BuiltInScalarFunction
extends SqlFunction {
    private final boolean isDeterministic;
    private final boolean isInternal;
    private final Function<SqlOperatorBinding, SqlMonotonicity> monotonicity;

    protected BuiltInScalarFunction(String name, SqlKind kind, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category, boolean isDeterministic, boolean isInternal, Function<SqlOperatorBinding, SqlMonotonicity> monotonicity) {
        super((String)Preconditions.checkNotNull((Object)name), (SqlKind)Preconditions.checkNotNull((Object)kind), returnTypeInference, operandTypeInference, operandTypeChecker, (SqlFunctionCategory)Preconditions.checkNotNull((Object)category));
        this.isDeterministic = isDeterministic;
        this.isInternal = isInternal;
        this.monotonicity = monotonicity;
    }

    protected BuiltInScalarFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        this(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category, true, false, call -> SqlMonotonicity.NOT_MONOTONIC);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public final boolean isInternal() {
        return this.isInternal;
    }

    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return this.monotonicity.apply(call);
    }

    public static class Builder {
        private String name;
        private SqlKind kind = SqlKind.OTHER_FUNCTION;
        private SqlReturnTypeInference returnTypeInference;
        private SqlOperandTypeInference operandTypeInference;
        private SqlOperandTypeChecker operandTypeChecker;
        private SqlFunctionCategory category = SqlFunctionCategory.SYSTEM;
        private boolean isInternal = false;
        private boolean isDeterministic = true;
        private Function<SqlOperatorBinding, SqlMonotonicity> monotonicity = call -> SqlMonotonicity.NOT_MONOTONIC;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder kind(SqlKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder returnType(SqlReturnTypeInference returnTypeInference) {
            this.returnTypeInference = returnTypeInference;
            return this;
        }

        public Builder operandTypeInference(SqlOperandTypeInference operandTypeInference) {
            this.operandTypeInference = operandTypeInference;
            return this;
        }

        public Builder operandTypeChecker(SqlOperandTypeChecker operandTypeChecker) {
            this.operandTypeChecker = operandTypeChecker;
            return this;
        }

        public Builder category(SqlFunctionCategory category) {
            this.category = category;
            return this;
        }

        public Builder notDeterministic() {
            this.isDeterministic = false;
            return this;
        }

        public Builder internal() {
            this.isInternal = true;
            return this;
        }

        public Builder monotonicity(SqlMonotonicity staticMonotonicity) {
            this.monotonicity = call -> staticMonotonicity;
            return this;
        }

        public Builder monotonicity(Function<SqlOperatorBinding, SqlMonotonicity> monotonicity) {
            this.monotonicity = monotonicity;
            return this;
        }

        public BuiltInScalarFunction build() {
            return new BuiltInScalarFunction(this.name, this.kind, this.returnTypeInference, this.operandTypeInference, this.operandTypeChecker, this.category, this.isDeterministic, this.isInternal, this.monotonicity);
        }
    }
}

