/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.MaskUtils;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class LinkedListSerializer<T>
extends TypeSerializer<LinkedList<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> elementSerializer;
    private final boolean hasNullMask;
    private transient boolean[] reuseMask;

    public LinkedListSerializer(TypeSerializer<T> elementSerializer) {
        this(elementSerializer, true);
    }

    public LinkedListSerializer(TypeSerializer<T> elementSerializer, boolean hasNullMask) {
        this.elementSerializer = (TypeSerializer)Preconditions.checkNotNull(elementSerializer);
        this.hasNullMask = hasNullMask;
    }

    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<LinkedList<T>> duplicate() {
        return new LinkedListSerializer<T>(this.elementSerializer.duplicate(), this.hasNullMask);
    }

    public LinkedList<T> createInstance() {
        return new LinkedList();
    }

    public LinkedList<T> copy(LinkedList<T> from) {
        LinkedList<Object> newList = new LinkedList<Object>();
        for (Object element : from) {
            if (element == null) {
                newList.add(null);
                continue;
            }
            newList.add(this.elementSerializer.copy(element));
        }
        return newList;
    }

    public LinkedList<T> copy(LinkedList<T> from, LinkedList<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    private void ensureReuseMaskLength(int len) {
        if (this.reuseMask == null || this.reuseMask.length < len) {
            this.reuseMask = new boolean[len];
        }
    }

    public void serialize(LinkedList<T> list, DataOutputView target) throws IOException {
        target.writeInt(list.size());
        if (this.hasNullMask) {
            this.ensureReuseMaskLength(list.size());
            MaskUtils.writeMask((boolean[])this.getNullMask(list), (int)list.size(), (DataOutputView)target);
        }
        for (Object element : list) {
            if (element == null) continue;
            this.elementSerializer.serialize(element, target);
        }
    }

    private boolean[] getNullMask(LinkedList<T> list) {
        int idx = 0;
        for (Object item : list) {
            this.reuseMask[idx] = item == null;
            ++idx;
        }
        return this.reuseMask;
    }

    public LinkedList<T> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.hasNullMask) {
            this.ensureReuseMaskLength(size);
            MaskUtils.readIntoMask((DataInputView)source, (boolean[])this.reuseMask, (int)size);
        }
        for (int i = 0; i < size; ++i) {
            if (this.hasNullMask && this.reuseMask[i]) {
                list.add(null);
                continue;
            }
            list.add(this.elementSerializer.deserialize(source));
        }
        return list;
    }

    public LinkedList<T> deserialize(LinkedList<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int num = source.readInt();
        target.writeInt(num);
        if (this.hasNullMask) {
            this.ensureReuseMaskLength(num);
            MaskUtils.readIntoAndCopyMask((DataInputView)source, (DataOutputView)target, (boolean[])this.reuseMask, (int)num);
        }
        for (int i = 0; i < num; ++i) {
            if (this.hasNullMask && this.reuseMask[i]) continue;
            this.elementSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.elementSerializer.equals(((LinkedListSerializer)((Object)obj)).elementSerializer);
    }

    public int hashCode() {
        return this.elementSerializer.hashCode();
    }

    public TypeSerializerSnapshot<LinkedList<T>> snapshotConfiguration() {
        return new LinkedListSerializerSnapshot(this);
    }

    public static class LinkedListSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<LinkedList<T>, LinkedListSerializer<T>> {
        private static final int CURRENT_VERSION = 3;
        private static final int FIRST_VERSION_WITH_NULL_MASK = 2;
        private boolean hasNullMask = true;

        public LinkedListSerializerSnapshot() {
            super(LinkedListSerializer.class);
        }

        public LinkedListSerializerSnapshot(LinkedListSerializer<T> listSerializer) {
            super(listSerializer);
            this.hasNullMask = ((LinkedListSerializer)listSerializer).hasNullMask;
        }

        public int getCurrentOuterSnapshotVersion() {
            return 3;
        }

        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.hasNullMask = readOuterSnapshotVersion < 2 ? false : (readOuterSnapshotVersion == 2 ? true : in.readBoolean());
        }

        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            out.writeBoolean(this.hasNullMask);
        }

        protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(LinkedListSerializer<T> newSerializer) {
            if (this.hasNullMask != ((LinkedListSerializer)newSerializer).hasNullMask) {
                return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION;
            }
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
        }

        protected LinkedListSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> elementSerializer = nestedSerializers[0];
            return new LinkedListSerializer(elementSerializer, this.hasNullMask);
        }

        protected TypeSerializer<?>[] getNestedSerializers(LinkedListSerializer<T> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.getElementSerializer()};
        }
    }
}

