/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class DoubleSerializer
extends TypeSerializerSingleton<Double> {
    private static final long serialVersionUID = 1L;
    public static final DoubleSerializer INSTANCE = new DoubleSerializer();
    private static final Double ZERO = 0.0;

    public boolean isImmutableType() {
        return true;
    }

    public Double createInstance() {
        return ZERO;
    }

    public Double copy(Double from) {
        return from;
    }

    public Double copy(Double from, Double reuse) {
        return from;
    }

    public int getLength() {
        return 8;
    }

    public void serialize(Double record, DataOutputView target) throws IOException {
        target.writeDouble(record.doubleValue());
    }

    public Double deserialize(DataInputView source) throws IOException {
        return source.readDouble();
    }

    public Double deserialize(Double reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeDouble(source.readDouble());
    }

    public TypeSerializerSnapshot<Double> snapshotConfiguration() {
        return new DoubleSerializerSnapshot();
    }

    public static final class DoubleSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Double> {
        public DoubleSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

