/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.event;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;

public class SchemaChangeResponse
implements CoordinationResponse {
    private static final long serialVersionUID = 1L;
    private final List<SchemaChangeEvent> schemaChangeEvents;
    private final ResponseCode responseCode;

    public static SchemaChangeResponse accepted(List<SchemaChangeEvent> schemaChangeEvents) {
        return new SchemaChangeResponse(schemaChangeEvents, ResponseCode.ACCEPTED);
    }

    public static SchemaChangeResponse busy() {
        return new SchemaChangeResponse(Collections.emptyList(), ResponseCode.BUSY);
    }

    public static SchemaChangeResponse duplicate() {
        return new SchemaChangeResponse(Collections.emptyList(), ResponseCode.DUPLICATE);
    }

    public static SchemaChangeResponse ignored() {
        return new SchemaChangeResponse(Collections.emptyList(), ResponseCode.IGNORED);
    }

    private SchemaChangeResponse(List<SchemaChangeEvent> schemaChangeEvents, ResponseCode responseCode) {
        this.schemaChangeEvents = schemaChangeEvents;
        this.responseCode = responseCode;
    }

    public boolean isAccepted() {
        return ResponseCode.ACCEPTED.equals((Object)this.responseCode);
    }

    public boolean isRegistryBusy() {
        return ResponseCode.BUSY.equals((Object)this.responseCode);
    }

    public boolean isDuplicate() {
        return ResponseCode.DUPLICATE.equals((Object)this.responseCode);
    }

    public boolean isIgnored() {
        return ResponseCode.IGNORED.equals((Object)this.responseCode);
    }

    public List<SchemaChangeEvent> getSchemaChangeEvents() {
        return this.schemaChangeEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaChangeResponse)) {
            return false;
        }
        SchemaChangeResponse response = (SchemaChangeResponse)o;
        return Objects.equals(this.schemaChangeEvents, response.schemaChangeEvents) && this.responseCode == response.responseCode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaChangeEvents, this.responseCode});
    }

    public String toString() {
        return "SchemaChangeResponse{schemaChangeEvents=" + this.schemaChangeEvents + ", responseCode=" + (Object)((Object)this.responseCode) + '}';
    }

    public static enum ResponseCode {
        ACCEPTED,
        BUSY,
        DUPLICATE,
        IGNORED;

    }
}

