/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.coordinator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaManager.class);
    private static final int INITIAL_SCHEMA_VERSION = 0;
    private static final int VERSIONS_TO_KEEP = 3;
    public static final Serializer SERIALIZER = new Serializer();
    private final Map<TableId, SortedMap<Integer, Schema>> tableSchemas;

    public SchemaManager() {
        this.tableSchemas = new HashMap<TableId, SortedMap<Integer, Schema>>();
    }

    public SchemaManager(Map<TableId, SortedMap<Integer, Schema>> tableSchemas) {
        this.tableSchemas = tableSchemas;
    }

    public final boolean schemaExists(TableId tableId) {
        return this.tableSchemas.containsKey(tableId) && !this.tableSchemas.get(tableId).isEmpty();
    }

    public Optional<Schema> getLatestSchema(TableId tableId) {
        return this.getLatestSchemaVersion(tableId).map(version -> (Schema)this.tableSchemas.get(tableId).get(version));
    }

    public Schema getSchema(TableId tableId, int version) {
        Preconditions.checkArgument((boolean)this.tableSchemas.containsKey(tableId), (String)"Unable to find schema for table \"%s\"", (Object[])new Object[]{tableId});
        SortedMap<Integer, Schema> versionedSchemas = this.tableSchemas.get(tableId);
        Preconditions.checkArgument((boolean)versionedSchemas.containsKey(version), (String)"Schema version %s does not exist for table \"%s\"", (Object[])new Object[]{version, tableId});
        return (Schema)versionedSchemas.get(version);
    }

    public void applySchemaChange(SchemaChangeEvent schemaChangeEvent) {
        if (schemaChangeEvent instanceof CreateTableEvent) {
            this.handleCreateTableEvent((CreateTableEvent)schemaChangeEvent);
        } else {
            Optional<Schema> optionalSchema = this.getLatestSchema(schemaChangeEvent.tableId());
            Preconditions.checkArgument((boolean)optionalSchema.isPresent(), (String)"Unable to apply SchemaChangeEvent for table \"%s\" without existing schema", (Object[])new Object[]{schemaChangeEvent.tableId()});
            LOG.info("Handling schema change event: {}", (Object)schemaChangeEvent);
            this.registerNewSchema(schemaChangeEvent.tableId(), SchemaUtils.applySchemaChangeEvent((Schema)optionalSchema.get(), (SchemaChangeEvent)schemaChangeEvent));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaManager that = (SchemaManager)o;
        return Objects.equals(this.tableSchemas, that.tableSchemas);
    }

    public int hashCode() {
        return Objects.hash(this.tableSchemas);
    }

    private Optional<Integer> getLatestSchemaVersion(TableId tableId) {
        if (!this.tableSchemas.containsKey(tableId)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.tableSchemas.get(tableId).lastKey());
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    private void handleCreateTableEvent(CreateTableEvent event) {
        Preconditions.checkArgument((!this.schemaExists(event.tableId()) ? 1 : 0) != 0, (String)"Unable to apply CreateTableEvent to an existing schema for table \"%s\"", (Object[])new Object[]{event.tableId()});
        LOG.info("Handling schema change event: {}", (Object)event);
        this.registerNewSchema(event.tableId(), event.getSchema());
    }

    private void registerNewSchema(TableId tableId, Schema newSchema) {
        if (this.schemaExists(tableId)) {
            SortedMap<Integer, Schema> versionedSchemas = this.tableSchemas.get(tableId);
            Integer latestVersion = versionedSchemas.lastKey();
            versionedSchemas.put(latestVersion + 1, newSchema);
            if (versionedSchemas.size() > 3) {
                versionedSchemas.remove(versionedSchemas.firstKey());
            }
        } else {
            TreeMap<Integer, Schema> versionedSchemas = new TreeMap<Integer, Schema>();
            versionedSchemas.put(0, newSchema);
            this.tableSchemas.putIfAbsent(tableId, versionedSchemas);
        }
    }

    static /* synthetic */ Map access$000(SchemaManager x0) {
        return x0.tableSchemas;
    }

    public static class Serializer
    implements SimpleVersionedSerializer<SchemaManager> {
        public static final int CURRENT_VERSION = 1;

        public int getVersion() {
            return 1;
        }

        /*
         * Exception decompiling
         */
        public byte[] serialize(SchemaManager schemaManager) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public SchemaManager deserialize(int version, byte[] serialized) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

