/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.parser.TransformParser;

public class TransformFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String scriptExpression;
    private final List<String> columnNames;

    public TransformFilter(String expression, String scriptExpression, List<String> columnNames) {
        this.expression = expression;
        this.scriptExpression = scriptExpression;
        this.columnNames = columnNames;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public static Optional<TransformFilter> of(String filterExpression) {
        if (StringUtils.isNullOrWhitespaceOnly((String)filterExpression)) {
            return Optional.empty();
        }
        List<String> columnNames = TransformParser.parseFilterColumnNameList(filterExpression);
        String scriptExpression = TransformParser.translateFilterExpressionToJaninoExpression(filterExpression);
        return Optional.of(new TransformFilter(filterExpression, scriptExpression, columnNames));
    }

    public boolean isVaild() {
        return !this.columnNames.isEmpty();
    }
}

