/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.operators.schema.event.CoordinationResponseUtils;
import org.apache.flink.cdc.runtime.operators.schema.event.FlushSuccessEvent;
import org.apache.flink.cdc.runtime.operators.schema.event.GetSchemaRequest;
import org.apache.flink.cdc.runtime.operators.schema.event.GetSchemaResponse;
import org.apache.flink.cdc.runtime.operators.schema.event.SinkWriterRegisterEvent;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.SerializedValue;

public class SchemaEvolutionClient {
    private final TaskOperatorEventGateway toCoordinator;
    private final OperatorID schemaOperatorID;

    public SchemaEvolutionClient(TaskOperatorEventGateway toCoordinator, OperatorID schemaOperatorID) {
        this.toCoordinator = toCoordinator;
        this.schemaOperatorID = schemaOperatorID;
    }

    public void registerSubtask(int subtask) throws IOException {
        this.toCoordinator.sendOperatorEventToCoordinator(this.schemaOperatorID, new SerializedValue((Object)new SinkWriterRegisterEvent(subtask)));
    }

    public void notifyFlushSuccess(int subtask, TableId tableId) throws IOException {
        this.toCoordinator.sendOperatorEventToCoordinator(this.schemaOperatorID, new SerializedValue((Object)new FlushSuccessEvent(subtask, tableId)));
    }

    public Optional<Schema> getLatestSchema(TableId tableId) throws Exception {
        GetSchemaResponse getSchemaResponse = (GetSchemaResponse)CoordinationResponseUtils.unwrap((CoordinationResponse)this.toCoordinator.sendRequestToCoordinator(this.schemaOperatorID, new SerializedValue((Object)GetSchemaRequest.ofLatestSchema(tableId))).get());
        return getSchemaResponse.getSchema();
    }
}

