/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.values.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;

public class ValuesDataSinkHelper {
    public static String convertEventToStr(Event event, List<RecordData.FieldGetter> fieldGetters) {
        if (event instanceof SchemaChangeEvent) {
            return event.toString();
        }
        if (event instanceof DataChangeEvent) {
            DataChangeEvent dataChangeEvent = (DataChangeEvent)event;
            String eventStr = "DataChangeEvent{tableId=" + dataChangeEvent.tableId() + ", before=" + ValuesDataSinkHelper.getFields(fieldGetters, dataChangeEvent.before()) + ", after=" + ValuesDataSinkHelper.getFields(fieldGetters, dataChangeEvent.after()) + ", op=" + dataChangeEvent.op() + ", meta=" + dataChangeEvent.describeMeta() + '}';
            return eventStr;
        }
        return "Event{}";
    }

    private static List<Object> getFields(List<RecordData.FieldGetter> fieldGetters, RecordData recordData) {
        ArrayList<Object> fields = new ArrayList<Object>(fieldGetters.size());
        if (recordData == null) {
            return fields;
        }
        for (RecordData.FieldGetter fieldGetter : fieldGetters) {
            fields.add(fieldGetter.getFieldOrNull(recordData));
        }
        return fields;
    }
}

