/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.values.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.binary.BinaryStringData;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.runtime.typeutils.BinaryRecordDataGenerator;

public class ValuesDataSourceHelper {
    public static final TableId TABLE_1 = TableId.tableId((String)"default_namespace", (String)"default_schema", (String)"table1");
    public static final TableId TABLE_2 = TableId.tableId((String)"default_namespace", (String)"default_schema", (String)"table2");
    private static List<List<Event>> sourceEvents;

    public static List<List<Event>> getSourceEvents() {
        if (sourceEvents == null) {
            sourceEvents = ValuesDataSourceHelper.singleSplitSingleTable();
        }
        ArrayList<Event> mergeEvents = new ArrayList<Event>();
        for (List<Event> events : sourceEvents) {
            mergeEvents.addAll(events);
        }
        return Collections.singletonList(mergeEvents);
    }

    public static void setSourceEvents(List<List<Event>> customSourceEvents) {
        sourceEvents = customSourceEvents;
    }

    public static void setSourceEvents(EventSetId eventType) {
        switch (eventType) {
            case SINGLE_SPLIT_SINGLE_TABLE: {
                sourceEvents = ValuesDataSourceHelper.singleSplitSingleTable();
                break;
            }
            case SINGLE_SPLIT_MULTI_TABLES: {
                sourceEvents = ValuesDataSourceHelper.singleSplitMultiTables();
                break;
            }
            case MULTI_SPLITS_SINGLE_TABLE: {
                sourceEvents = ValuesDataSourceHelper.multiSplitsSingleTable();
                break;
            }
            case CUSTOM_SOURCE_EVENTS: {
                break;
            }
            case TRANSFORM_TABLE: {
                sourceEvents = ValuesDataSourceHelper.transformTable();
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)eventType) + " is not supported");
            }
        }
    }

    public static List<List<Event>> singleSplitSingleTable() {
        ArrayList<List<Event>> eventOfSplits = new ArrayList<List<Event>>();
        ArrayList<Object> split1 = new ArrayList<Object>();
        Schema schema = Schema.newBuilder().physicalColumn("col1", DataTypes.STRING()).physicalColumn("col2", DataTypes.STRING()).primaryKey(new String[]{"col1"}).build();
        CreateTableEvent createTableEvent = new CreateTableEvent(TABLE_1, schema);
        split1.add(createTableEvent);
        BinaryRecordDataGenerator generator = new BinaryRecordDataGenerator(RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING()}));
        DataChangeEvent insertEvent1 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")}));
        split1.add(insertEvent1);
        DataChangeEvent insertEvent2 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}));
        split1.add(insertEvent2);
        DataChangeEvent insertEvent3 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3")}));
        split1.add(insertEvent3);
        AddColumnEvent.ColumnWithPosition columnWithPosition = new AddColumnEvent.ColumnWithPosition((Column)Column.physicalColumn((String)"col3", (DataType)DataTypes.STRING()));
        AddColumnEvent addColumnEvent = new AddColumnEvent(TABLE_1, Collections.singletonList(columnWithPosition));
        split1.add(addColumnEvent);
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("col2", "newCol2");
        nameMapping.put("col3", "newCol3");
        RenameColumnEvent renameColumnEvent = new RenameColumnEvent(TABLE_1, nameMapping);
        split1.add(renameColumnEvent);
        DropColumnEvent dropColumnEvent = new DropColumnEvent(TABLE_1, Collections.singletonList("newCol2"));
        split1.add(dropColumnEvent);
        split1.add(DataChangeEvent.deleteEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")})));
        split1.add(DataChangeEvent.updateEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"")}), (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"x")})));
        eventOfSplits.add(split1);
        return eventOfSplits;
    }

    public static List<List<Event>> singleSplitMultiTables() {
        ArrayList<List<Event>> eventOfSplits = new ArrayList<List<Event>>();
        ArrayList<Object> split1 = new ArrayList<Object>();
        Schema schema = Schema.newBuilder().physicalColumn("col1", DataTypes.STRING()).physicalColumn("col2", DataTypes.STRING()).primaryKey(new String[]{"col1"}).build();
        CreateTableEvent createTableEvent = new CreateTableEvent(TABLE_1, schema);
        split1.add(createTableEvent);
        CreateTableEvent createTableEvent2 = new CreateTableEvent(TABLE_2, schema);
        split1.add(createTableEvent2);
        BinaryRecordDataGenerator generator = new BinaryRecordDataGenerator(RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING()}));
        DataChangeEvent insertEvent1 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")}));
        split1.add(insertEvent1);
        DataChangeEvent insertEvent2 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}));
        split1.add(insertEvent2);
        DataChangeEvent insertEvent3 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3")}));
        split1.add(insertEvent3);
        AddColumnEvent.ColumnWithPosition columnWithPosition = new AddColumnEvent.ColumnWithPosition((Column)Column.physicalColumn((String)"col3", (DataType)DataTypes.STRING()));
        AddColumnEvent addColumnEvent = new AddColumnEvent(TABLE_1, Collections.singletonList(columnWithPosition));
        split1.add(addColumnEvent);
        insertEvent1 = DataChangeEvent.insertEvent((TableId)TABLE_2, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")}));
        split1.add(insertEvent1);
        insertEvent2 = DataChangeEvent.insertEvent((TableId)TABLE_2, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}));
        split1.add(insertEvent2);
        insertEvent3 = DataChangeEvent.insertEvent((TableId)TABLE_2, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3")}));
        split1.add(insertEvent3);
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("col2", "newCol2");
        nameMapping.put("col3", "newCol3");
        RenameColumnEvent renameColumnEvent = new RenameColumnEvent(TABLE_1, nameMapping);
        split1.add(renameColumnEvent);
        DropColumnEvent dropColumnEvent = new DropColumnEvent(TABLE_1, Collections.singletonList("newCol2"));
        split1.add(dropColumnEvent);
        split1.add(DataChangeEvent.deleteEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")})));
        split1.add(DataChangeEvent.updateEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}), (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"x")})));
        eventOfSplits.add(split1);
        return eventOfSplits;
    }

    public static List<List<Event>> multiSplitsSingleTable() {
        ArrayList<List<Event>> eventOfSplits = new ArrayList<List<Event>>();
        ArrayList<Object> split1 = new ArrayList<Object>();
        Schema schema = Schema.newBuilder().physicalColumn("col1", DataTypes.STRING()).physicalColumn("col2", DataTypes.STRING()).primaryKey(new String[]{"col1"}).build();
        CreateTableEvent createTableEvent = new CreateTableEvent(TABLE_1, schema);
        split1.add(createTableEvent);
        BinaryRecordDataGenerator generator = new BinaryRecordDataGenerator(RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING()}));
        DataChangeEvent insertEvent1 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")}));
        split1.add(insertEvent1);
        DataChangeEvent insertEvent2 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}));
        split1.add(insertEvent2);
        eventOfSplits.add(split1);
        ArrayList<Object> split2 = new ArrayList<Object>();
        split2.add(createTableEvent);
        DataChangeEvent insertEvent3 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3")}));
        split2.add(insertEvent3);
        DataChangeEvent insertEvent4 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"4"), BinaryStringData.fromString((String)"4")}));
        split2.add(insertEvent4);
        eventOfSplits.add(split2);
        ArrayList<Object> split3 = new ArrayList<Object>();
        split3.add(createTableEvent);
        DataChangeEvent insertEvent5 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"5"), BinaryStringData.fromString((String)"5")}));
        split3.add(insertEvent5);
        DataChangeEvent insertEvent6 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"6"), BinaryStringData.fromString((String)"6")}));
        split3.add(insertEvent6);
        eventOfSplits.add(split3);
        ArrayList<Object> split4 = new ArrayList<Object>();
        split4.add(createTableEvent);
        DataChangeEvent deleteEvent1 = DataChangeEvent.deleteEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}));
        split4.add(deleteEvent1);
        DataChangeEvent deleteEvent2 = DataChangeEvent.deleteEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"4"), BinaryStringData.fromString((String)"4")}));
        split4.add(deleteEvent2);
        DataChangeEvent deleteEvent3 = DataChangeEvent.deleteEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"6"), BinaryStringData.fromString((String)"6")}));
        split4.add(deleteEvent3);
        AddColumnEvent.ColumnWithPosition columnWithPosition = new AddColumnEvent.ColumnWithPosition((Column)Column.physicalColumn((String)"col3", (DataType)DataTypes.STRING()));
        AddColumnEvent addColumnEvent = new AddColumnEvent(TABLE_1, Collections.singletonList(columnWithPosition));
        split4.add(addColumnEvent);
        generator = new BinaryRecordDataGenerator(RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}));
        DataChangeEvent updateEvent1 = DataChangeEvent.updateEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"")}), (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"x")}));
        split4.add(updateEvent1);
        DataChangeEvent updateEvent2 = DataChangeEvent.updateEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"")}), (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"x")}));
        split4.add(updateEvent2);
        eventOfSplits.add(split4);
        return eventOfSplits;
    }

    public static List<List<Event>> transformTable() {
        ArrayList<List<Event>> eventOfSplits = new ArrayList<List<Event>>();
        ArrayList<Object> split1 = new ArrayList<Object>();
        Schema schema = Schema.newBuilder().physicalColumn("col1", DataTypes.STRING()).physicalColumn("col2", DataTypes.STRING()).primaryKey(new String[]{"col1"}).build();
        CreateTableEvent createTableEvent = new CreateTableEvent(TABLE_1, schema);
        split1.add(createTableEvent);
        BinaryRecordDataGenerator generator = new BinaryRecordDataGenerator(RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING()}));
        DataChangeEvent insertEvent1 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")}));
        split1.add(insertEvent1);
        DataChangeEvent insertEvent2 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"2")}));
        split1.add(insertEvent2);
        DataChangeEvent insertEvent3 = DataChangeEvent.insertEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"3"), BinaryStringData.fromString((String)"3")}));
        split1.add(insertEvent3);
        AddColumnEvent.ColumnWithPosition columnWithPosition = new AddColumnEvent.ColumnWithPosition((Column)Column.physicalColumn((String)"col3", (DataType)DataTypes.STRING()));
        AddColumnEvent addColumnEvent = new AddColumnEvent(TABLE_1, Collections.singletonList(columnWithPosition));
        split1.add(addColumnEvent);
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("col2", "newCol2");
        nameMapping.put("col3", "newCol3");
        RenameColumnEvent renameColumnEvent = new RenameColumnEvent(TABLE_1, nameMapping);
        split1.add(renameColumnEvent);
        DropColumnEvent dropColumnEvent = new DropColumnEvent(TABLE_1, Collections.singletonList("newCol2"));
        split1.add(dropColumnEvent);
        split1.add(DataChangeEvent.deleteEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"1"), BinaryStringData.fromString((String)"1")})));
        split1.add(DataChangeEvent.updateEvent((TableId)TABLE_1, (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"")}), (RecordData)generator.generate(new Object[]{BinaryStringData.fromString((String)"2"), BinaryStringData.fromString((String)"x")})));
        eventOfSplits.add(split1);
        return eventOfSplits;
    }

    public static enum EventSetId {
        SINGLE_SPLIT_SINGLE_TABLE,
        SINGLE_SPLIT_MULTI_TABLES,
        MULTI_SPLITS_SINGLE_TABLE,
        CUSTOM_SOURCE_EVENTS,
        TRANSFORM_TABLE;

    }
}

