/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.values;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.common.source.MetadataAccessor;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ValuesDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(ValuesDatabase.class);
    private static final Map<TableId, ValuesTable> globalTables = new ConcurrentHashMap<TableId, ValuesTable>();

    public static Schema getTableSchema(TableId tableId) {
        ValuesTable table = globalTables.get(tableId);
        Preconditions.checkNotNull((Object)table, (String)(tableId + " is not existed"));
        Schema.Builder builder = Schema.newBuilder();
        for (Column column : table.columns) {
            builder.physicalColumn(column.getName(), column.getType());
        }
        return builder.primaryKey(table.primaryKeys).build();
    }

    public static void applyDataChangeEvent(DataChangeEvent event) {
        ValuesTable table = globalTables.get(event.tableId());
        Preconditions.checkNotNull((Object)table, (String)(event.tableId() + " is not existed"));
        table.applyDataChangeEvent(event);
        LOG.info("apply DataChangeEvent: " + event);
    }

    public static void applySchemaChangeEvent(SchemaChangeEvent event) {
        TableId tableId = event.tableId();
        if (event instanceof CreateTableEvent) {
            if (!globalTables.containsKey(tableId)) {
                globalTables.put(tableId, new ValuesTable(tableId, ((CreateTableEvent)event).getSchema()));
            }
        } else {
            ValuesTable table = globalTables.get(event.tableId());
            Preconditions.checkNotNull((Object)table, (String)(event.tableId() + " is not existed"));
            table.applySchemaChangeEvent(event);
        }
    }

    public static List<String> getAllResults() {
        ArrayList<String> results = new ArrayList<String>();
        globalTables.values().forEach(valuesTable -> results.addAll(valuesTable.getResult()));
        return results;
    }

    public static List<String> getResults(TableId tableId) {
        ValuesTable table = globalTables.get(tableId);
        Preconditions.checkNotNull((Object)table, (String)(tableId + " is not existed"));
        return table.getResult();
    }

    public static void clear() {
        globalTables.clear();
    }

    private static class ValuesTable {
        private final Object lock;
        private final TableId tableId;
        private final Map<String, Map<String, String>> records;
        private final LinkedList<Column> columns;
        private final LinkedList<String> columnNames;
        private final List<String> primaryKeys;
        private final List<Integer> primaryKeyIndexes;

        public ValuesTable(TableId tableId, Schema schema) {
            this.tableId = tableId;
            this.lock = new Object();
            this.columns = new LinkedList(schema.getColumns());
            this.columnNames = new LinkedList(schema.getColumnNames());
            this.records = new HashMap<String, Map<String, String>>();
            this.primaryKeys = new LinkedList<String>(schema.primaryKeys());
            this.primaryKeyIndexes = new ArrayList<Integer>();
            this.updatePrimaryKeyIndexes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getResult() {
            ArrayList<String> results = new ArrayList<String>();
            Object object = this.lock;
            synchronized (object) {
                this.records.forEach((key, record) -> {
                    StringBuilder stringBuilder = new StringBuilder(this.tableId.toString());
                    stringBuilder.append(":");
                    for (Column column : this.columns) {
                        stringBuilder.append(column.getName()).append("=").append(record.getOrDefault(column.getName(), "")).append(";");
                    }
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    results.add(stringBuilder.toString());
                });
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyDataChangeEvent(DataChangeEvent event) {
            Object object = this.lock;
            synchronized (object) {
                switch (event.op()) {
                    case INSERT: {
                        this.insert(event.after());
                        break;
                    }
                    case DELETE: {
                        this.delete(event.before());
                        break;
                    }
                    case REPLACE: 
                    case UPDATE: {
                        this.update(event.before(), event.after());
                    }
                }
            }
        }

        private void delete(RecordData recordData) {
            this.records.remove(this.buildPrimaryKeyStr(recordData));
        }

        private void insert(RecordData recordData) {
            String primaryKey = this.buildPrimaryKeyStr(recordData);
            HashMap<String, String> record = new HashMap<String, String>();
            for (int i = 0; i < recordData.getArity(); ++i) {
                record.put(this.columns.get(i).getName(), recordData.getString(i).toString());
            }
            this.records.put(primaryKey, record);
        }

        private void update(RecordData beforeRecordData, RecordData afterRecordData) {
            this.insert(afterRecordData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applySchemaChangeEvent(SchemaChangeEvent event) {
            Object object = this.lock;
            synchronized (object) {
                if (event instanceof AddColumnEvent) {
                    this.applyAddColumnEvent((AddColumnEvent)event);
                } else if (event instanceof DropColumnEvent) {
                    this.applyDropColumnEvent((DropColumnEvent)event);
                } else if (event instanceof RenameColumnEvent) {
                    this.applyRenameColumnEvent((RenameColumnEvent)event);
                } else if (event instanceof AlterColumnTypeEvent) {
                    this.applyAlterColumnTypeEvent((AlterColumnTypeEvent)event);
                }
                this.updatePrimaryKeyIndexes();
            }
        }

        private void updatePrimaryKeyIndexes() {
            Preconditions.checkArgument((!this.primaryKeys.isEmpty() ? 1 : 0) != 0, (String)"primaryKeys couldn't be empty", (Object[])new Object[0]);
            this.primaryKeyIndexes.clear();
            for (String primaryKey : this.primaryKeys) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    if (!this.columns.get(i).getName().equals(primaryKey)) continue;
                    this.primaryKeyIndexes.add(i);
                }
            }
            this.primaryKeyIndexes.sort(Comparator.naturalOrder());
        }

        private String buildPrimaryKeyStr(RecordData recordData) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer primaryKeyIndex : this.primaryKeyIndexes) {
                stringBuilder.append(recordData.getString(primaryKeyIndex.intValue()).toString()).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        private void applyAlterColumnTypeEvent(AlterColumnTypeEvent event) {
            event.getTypeMapping().forEach((columnName, columnType) -> {
                for (int i = 0; i < this.columns.size(); ++i) {
                    if (!this.columns.get(i).getName().equals(columnName)) continue;
                    this.columns.set(i, (Column)Column.physicalColumn((String)columnName, (DataType)columnType));
                }
            });
        }

        private void applyAddColumnEvent(AddColumnEvent event) {
            for (AddColumnEvent.ColumnWithPosition columnWithPosition : event.getAddedColumns()) {
                if (this.columns.contains(columnWithPosition.getAddColumn())) {
                    throw new IllegalArgumentException(columnWithPosition.getAddColumn().getName() + " is already existed");
                }
                switch (columnWithPosition.getPosition()) {
                    case FIRST: {
                        this.columns.addFirst(columnWithPosition.getAddColumn());
                        this.columnNames.addFirst(columnWithPosition.getAddColumn().getName());
                        break;
                    }
                    case LAST: {
                        this.columns.addLast(columnWithPosition.getAddColumn());
                        this.columnNames.addLast(columnWithPosition.getAddColumn().getName());
                        break;
                    }
                    case BEFORE: {
                        int index = this.columnNames.indexOf(columnWithPosition.getExistedColumnName());
                        this.columns.add(index, columnWithPosition.getAddColumn());
                        this.columnNames.add(index, columnWithPosition.getAddColumn().getName());
                        break;
                    }
                    case AFTER: {
                        int index = this.columnNames.indexOf(columnWithPosition.getExistedColumnName());
                        this.columns.add(index + 1, columnWithPosition.getAddColumn());
                        this.columnNames.add(index + 1, columnWithPosition.getAddColumn().getName());
                        break;
                    }
                }
            }
        }

        private void applyDropColumnEvent(DropColumnEvent event) {
            for (String columnName : event.getDroppedColumnNames()) {
                if (!this.removeColumn(columnName)) {
                    throw new IllegalArgumentException(columnName + " is not existed");
                }
                this.records.forEach((key, record) -> {
                    String cfr_ignored_0 = (String)record.remove(columnName);
                });
            }
        }

        private boolean removeColumn(String columnName) {
            int index = this.columnNames.indexOf(columnName);
            if (index == -1) {
                return false;
            }
            return Objects.nonNull(this.columnNames.remove(index)) && Objects.nonNull(this.columns.remove(index));
        }

        private void applyRenameColumnEvent(RenameColumnEvent event) {
            event.getNameMapping().forEach((beforeName, afterName) -> {
                for (int i = 0; i < this.columns.size(); ++i) {
                    if (!this.columns.get(i).getName().equals(beforeName)) continue;
                    Column column = this.columns.get(i);
                    this.columns.set(i, (Column)Column.physicalColumn((String)afterName, (DataType)column.getType()));
                    this.columnNames.set(i, (String)afterName);
                }
                this.records.forEach((key, record) -> {
                    if (record.containsKey(beforeName)) {
                        String value = (String)record.get(beforeName);
                        record.remove(beforeName);
                        record.put(afterName, value);
                    }
                });
            });
        }
    }

    public static class ValuesMetadataAccessor
    implements MetadataAccessor {
        public List<String> listNamespaces() throws UnsupportedOperationException {
            HashSet namespaces = new HashSet();
            globalTables.keySet().forEach(tableId -> namespaces.add(tableId.getNamespace()));
            return new ArrayList<String>(namespaces);
        }

        public List<String> listSchemas(@Nullable String namespace) throws UnsupportedOperationException {
            HashSet schemas = new HashSet();
            globalTables.keySet().stream().filter(tableId -> {
                if (namespace == null) {
                    return tableId.getNamespace() == null;
                }
                return namespace.equals(tableId.getNamespace());
            }).forEach(tableId -> schemas.add(tableId.getSchemaName()));
            return new ArrayList<String>(schemas);
        }

        public List<TableId> listTables(@Nullable String namespace, @Nullable String schemaName) {
            return globalTables.keySet().stream().filter(tableId -> {
                if (namespace == null) {
                    if (schemaName == null) {
                        return tableId.getNamespace() == null && tableId.getSchemaName() == null;
                    }
                    return tableId.getNamespace() == null && schemaName.equals(tableId.getSchemaName());
                }
                return namespace.equals(tableId.getNamespace()) && schemaName.equals(tableId.getSchemaName());
            }).collect(Collectors.toList());
        }

        public Schema getTableSchema(TableId tableId) {
            return ValuesDatabase.getTableSchema(tableId);
        }
    }

    public static class ValuesMetadataApplier
    implements MetadataApplier {
        public void applySchemaChange(SchemaChangeEvent schemaChangeEvent) {
            ValuesDatabase.applySchemaChangeEvent(schemaChangeEvent);
        }
    }
}

