/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.schema.SchemaSerializer;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeJsonParser;
import org.apache.paimon.utils.JsonDeserializer;
import org.apache.paimon.utils.JsonSerializer;

public class JsonSerdeUtil {
    private static final ObjectMapper OBJECT_MAPPER_INSTANCE = new ObjectMapper();

    public static <V> LinkedHashMap<String, V> parseJsonMap(String jsonString, Class<V> valueType) {
        try {
            LinkedHashMap<String, Object> originalMap = OBJECT_MAPPER_INSTANCE.readValue(jsonString, new TypeReference<LinkedHashMap<String, Object>>(){});
            return originalMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Object value = entry.getValue();
                try {
                    if (!valueType.isInstance(value)) {
                        String jsonStr = OBJECT_MAPPER_INSTANCE.writeValueAsString(value);
                        return OBJECT_MAPPER_INSTANCE.convertValue((Object)jsonStr, valueType);
                    }
                    return OBJECT_MAPPER_INSTANCE.convertValue(value, valueType);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error converting value to JSON string", e);
                }
            }, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error parsing JSON string", e);
        }
    }

    @Nullable
    public static <T extends JsonNode> T getNodeAs(JsonNode root, String fieldName, Class<T> clazz) {
        JsonNode node = root.get(fieldName);
        if (node == null) {
            return null;
        }
        if (clazz.isInstance(node)) {
            return (T)((JsonNode)clazz.cast(node));
        }
        throw new IllegalArgumentException(String.format("Expected node '%s' to be of type %s but was %s.", fieldName, clazz.getName(), node.getClass().getName()));
    }

    public static <T> T fromJson(String json, TypeReference<T> typeReference) {
        try {
            return OBJECT_MAPPER_INSTANCE.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return OBJECT_MAPPER_INSTANCE.reader().readValue(json, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> String toJson(T t) {
        try {
            return OBJECT_MAPPER_INSTANCE.writerWithDefaultPrettyPrinter().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> String toFlatJson(T t) {
        try {
            return OBJECT_MAPPER_INSTANCE.writer().writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Module createPaimonJacksonModule() {
        SimpleModule module = new SimpleModule("Paimon");
        JsonSerdeUtil.registerJsonObjects(module, TableSchema.class, SchemaSerializer.INSTANCE, SchemaSerializer.INSTANCE);
        JsonSerdeUtil.registerJsonObjects(module, DataField.class, DataField::serializeJson, DataTypeJsonParser::parseDataField);
        JsonSerdeUtil.registerJsonObjects(module, DataType.class, DataType::serializeJson, DataTypeJsonParser::parseDataType);
        return module;
    }

    private static <T> void registerJsonObjects(SimpleModule module, Class<T> clazz, final JsonSerializer<T> serializer, final JsonDeserializer<T> deserializer) {
        module.addSerializer(new StdSerializer<T>(clazz){

            @Override
            public void serialize(T t, JsonGenerator generator, SerializerProvider provider) throws IOException {
                serializer.serialize(t, generator);
            }
        });
        module.addDeserializer(clazz, new StdDeserializer<T>(clazz){

            @Override
            public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                return deserializer.deserialize((JsonNode)parser.readValueAsTree());
            }
        });
    }

    public static <T extends JsonNode> T asSpecificNodeType(String json, Class<T> clazz) throws JsonProcessingException {
        JsonNode resultNode = OBJECT_MAPPER_INSTANCE.readTree(json);
        if (!clazz.isInstance(resultNode)) {
            throw new IllegalArgumentException("Expected node of type " + clazz.getName() + " but was " + resultNode.getClass().getName());
        }
        return (T)((JsonNode)clazz.cast(resultNode));
    }

    public static <T> T extractValueOrDefault(JsonNode jsonNode, Class<T> valueType, T defaultValue, String ... path) throws JsonProcessingException {
        for (String key : path) {
            if ((jsonNode = jsonNode.get(key)) != null) continue;
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Invalid path or key not found: " + key);
        }
        return OBJECT_MAPPER_INSTANCE.treeToValue((TreeNode)jsonNode, valueType);
    }

    public static <T> T extractValue(JsonNode jsonNode, Class<T> valueType, String ... path) throws JsonProcessingException {
        return JsonSerdeUtil.extractValueOrDefault(jsonNode, valueType, null, path);
    }

    public static boolean isNodeExists(JsonNode jsonNode, String ... path) {
        for (String key : path) {
            if ((jsonNode = jsonNode.get(key)) != null) continue;
            return false;
        }
        return true;
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return OBJECT_MAPPER_INSTANCE.convertValue(fromValue, toValueTypeRef);
    }

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER_INSTANCE.writer().writeValueAsString(value);
    }

    public static boolean isNull(JsonNode jsonNode) {
        return jsonNode == null || jsonNode.isNull();
    }

    private JsonSerdeUtil() {
    }

    static {
        OBJECT_MAPPER_INSTANCE.registerModule(JsonSerdeUtil.createPaimonJacksonModule());
        OBJECT_MAPPER_INSTANCE.registerModule(new JavaTimeModule());
    }
}

