/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TypeUtils;

public class InternalRowPartitionComputer {
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    protected final InternalRow.FieldGetter[] partitionFieldGetters;

    public InternalRowPartitionComputer(String defaultPartValue, RowType rowType, String[] partitionColumns) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        List<String> columnList = rowType.getFieldNames();
        this.partitionFieldGetters = (InternalRow.FieldGetter[])Arrays.stream(partitionColumns).mapToInt(columnList::indexOf).mapToObj(i -> InternalRowUtils.createNullCheckingFieldGetter(rowType.getTypeAt(i), i)).toArray(InternalRow.FieldGetter[]::new);
    }

    public LinkedHashMap<String, String> generatePartValues(InternalRow in) {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionFieldGetters.length; ++i) {
            String partitionValue;
            Object field = this.partitionFieldGetters[i].getFieldOrNull(in);
            String string = partitionValue = field != null ? field.toString() : null;
            if (StringUtils.isNullOrWhitespaceOnly(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }

    public static Map<String, Object> convertSpecToInternal(Map<String, String> spec, RowType partType, String defaultPartValue) {
        LinkedHashMap<String, Object> partValues = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : spec.entrySet()) {
            partValues.put(entry.getKey(), defaultPartValue.equals(entry.getValue()) ? null : TypeUtils.castFromString(entry.getValue(), partType.getField(entry.getKey()).type()));
        }
        return partValues;
    }

    public static String partToSimpleString(RowType partitionType, BinaryRow partition, String delimiter, int maxLength) {
        InternalRow.FieldGetter[] getters = partitionType.fieldGetters();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < getters.length; ++i) {
            Object part = getters[i].getFieldOrNull(partition);
            if (part != null) {
                builder.append(part);
            } else {
                builder.append("null");
            }
            if (i == getters.length - 1) continue;
            builder.append(delimiter);
        }
        String result = builder.toString();
        return result.substring(0, Math.min(result.length(), maxLength));
    }
}

