/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.ArrayListMultimap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.shade.guava30.com.google.common.collect.Multimap;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class AggregationFieldsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String AGGREGATION_FIELDS = "aggregation_fields";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "field_name", SerializationUtils.newStringType(false)), new DataField(1, "field_type", SerializationUtils.newStringType(false)), new DataField(2, "function", SerializationUtils.newStringType(true)), new DataField(3, "function_options", SerializationUtils.newStringType(true)), new DataField(4, "comment", SerializationUtils.newStringType(true))));
    private final FileIO fileIO;
    private final Path location;
    private final String branch;

    public AggregationFieldsTable(FileStoreTable dataTable) {
        this(dataTable.fileIO(), dataTable.location(), CoreOptions.branch(dataTable.schema().options()));
    }

    public AggregationFieldsTable(FileIO fileIO, Path location, String branchName) {
        this.fileIO = fileIO;
        this.location = location;
        this.branch = branchName;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + AGGREGATION_FIELDS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("field_name");
    }

    @Override
    public InnerTableScan newScan() {
        return new SchemasScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new SchemasRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new AggregationFieldsTable(this.fileIO, this.location, this.branch);
    }

    protected static Multimap<String, String> extractFieldMultimap(Map<String, String> inputMap, Function<Map.Entry<String, String>, String> contentSelector) {
        ArrayListMultimap<String, String> fieldMultimap = ArrayListMultimap.create();
        for (Map.Entry<String, String> entry : inputMap.entrySet()) {
            String[] keys = entry.getKey().split("\\.");
            if (keys.length <= 2 || !keys[0].equals("fields")) continue;
            String fieldKey = keys[1];
            String content = contentSelector.apply(entry);
            fieldMultimap.put(fieldKey, content);
        }
        return fieldMultimap;
    }

    private class SchemasRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;

        public SchemasRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof AggregationSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((AggregationSplit)split).location;
            TableSchema schemas = new SchemaManager(this.fileIO, location, AggregationFieldsTable.this.branch).latest().get();
            Iterator<InternalRow> rows = this.createInternalRowIterator(schemas);
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private Iterator<InternalRow> createInternalRowIterator(TableSchema schema) {
            Multimap<String, String> function = AggregationFieldsTable.extractFieldMultimap(schema.options(), Map.Entry::getValue);
            Multimap<String, String> functionOptions = AggregationFieldsTable.extractFieldMultimap(schema.options(), Map.Entry::getKey);
            ArrayList<GenericRow> internalRows = new ArrayList<GenericRow>();
            for (int i = 0; i < schema.fields().size(); ++i) {
                String fieldName = schema.fields().get(i).name();
                GenericRow genericRow = GenericRow.of(BinaryString.fromString(fieldName), BinaryString.fromString(schema.fields().get(i).type().toString()), BinaryString.fromString(function.get(fieldName).toString()), BinaryString.fromString(functionOptions.get(fieldName).toString()), BinaryString.fromString(schema.fields().get(i).description()));
                internalRows.add(genericRow);
            }
            return internalRows.iterator();
        }
    }

    private static class AggregationSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private AggregationSplit(Path location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregationSplit that = (AggregationSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class SchemasScan
    extends ReadOnceTableScan {
        private SchemasScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new AggregationSplit(AggregationFieldsTable.this.location));
        }
    }
}

