/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta08Serializer;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.utils.SerializationUtils;

public class CommitMessageSerializer
implements VersionedSerializer<CommitMessage> {
    private static final int CURRENT_VERSION = 3;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();
    private final IndexFileMetaSerializer indexEntrySerializer = new IndexFileMetaSerializer();
    private DataFileMeta08Serializer dataFile08Serializer;

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public byte[] serialize(CommitMessage obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        this.serialize(obj, view);
        return out.toByteArray();
    }

    public void serializeList(List<CommitMessage> list, DataOutputView view) throws IOException {
        view.writeInt(list.size());
        for (CommitMessage commitMessage : list) {
            this.serialize(commitMessage, view);
        }
    }

    private void serialize(CommitMessage obj, DataOutputView view) throws IOException {
        CommitMessageImpl message = (CommitMessageImpl)obj;
        SerializationUtils.serializeBinaryRow(obj.partition(), view);
        view.writeInt(obj.bucket());
        this.dataFileSerializer.serializeList(message.newFilesIncrement().newFiles(), view);
        this.dataFileSerializer.serializeList(message.newFilesIncrement().deletedFiles(), view);
        this.dataFileSerializer.serializeList(message.newFilesIncrement().changelogFiles(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().compactBefore(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().compactAfter(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().changelogFiles(), view);
        this.indexEntrySerializer.serializeList(message.indexIncrement().newIndexFiles(), view);
        this.indexEntrySerializer.serializeList(message.indexIncrement().deletedIndexFiles(), view);
    }

    @Override
    public CommitMessage deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize(version, view);
    }

    public List<CommitMessage> deserializeList(int version, DataInputView view) throws IOException {
        int length = view.readInt();
        ArrayList<CommitMessage> list = new ArrayList<CommitMessage>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(version, view));
        }
        return list;
    }

    private CommitMessage deserialize(int version, DataInputView view) throws IOException {
        if (version == 3) {
            return new CommitMessageImpl(SerializationUtils.deserializeBinaryRow(view), view.readInt(), new DataIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)), new CompactIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)), new IndexIncrement(this.indexEntrySerializer.deserializeList(view), this.indexEntrySerializer.deserializeList(view)));
        }
        if (version <= 2) {
            return this.deserialize08(version, view);
        }
        throw new UnsupportedOperationException("Expecting CommitMessageSerializer version to be smaller or equal than 3, but found " + version + ".");
    }

    private CommitMessage deserialize08(int version, DataInputView view) throws IOException {
        if (this.dataFile08Serializer == null) {
            this.dataFile08Serializer = new DataFileMeta08Serializer();
        }
        return new CommitMessageImpl(SerializationUtils.deserializeBinaryRow(view), view.readInt(), new DataIncrement(this.dataFile08Serializer.deserializeList(view), this.dataFile08Serializer.deserializeList(view), this.dataFile08Serializer.deserializeList(view)), new CompactIncrement(this.dataFile08Serializer.deserializeList(view), this.dataFile08Serializer.deserializeList(view), this.dataFile08Serializer.deserializeList(view)), new IndexIncrement(this.indexEntrySerializer.deserializeList(view), version <= 2 ? Collections.emptyList() : this.indexEntrySerializer.deserializeList(view)));
    }
}

