/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.network;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;

public class NetworkUtils {
    public static String findHostAddress() throws SocketException, UnknownHostException {
        return NetworkUtils.findLocalAddress().getHostAddress();
    }

    public static InetAddress findLocalAddress() throws UnknownHostException, SocketException {
        InetAddress localAddress = InetAddress.getLocalHost();
        if (localAddress.isLoopbackAddress()) {
            Enumeration<NetworkInterface> activeNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
            LinkedList<NetworkInterface> reversedNetworkInterfaces = new LinkedList<NetworkInterface>();
            while (activeNetworkInterfaces.hasMoreElements()) {
                reversedNetworkInterfaces.addFirst(activeNetworkInterfaces.nextElement());
            }
            for (NetworkInterface networkInterface : reversedNetworkInterfaces) {
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLinkLocalAddress() || address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    return InetAddress.getByAddress(address.getAddress());
                }
            }
        }
        return localAddress;
    }
}

