/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaMergingUtils;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@ThreadSafe
public class SchemaManager
implements Serializable {
    private static final String SCHEMA_PREFIX = "schema-";
    private final FileIO fileIO;
    private final Path tableRoot;
    @Nullable
    private transient Lock lock;
    private final String branch;

    public SchemaManager(FileIO fileIO, Path tableRoot) {
        this(fileIO, tableRoot, "main");
    }

    public SchemaManager(FileIO fileIO, Path tableRoot, String branch) {
        this.fileIO = fileIO;
        this.tableRoot = tableRoot;
        this.branch = StringUtils.isBlank(branch) ? "main" : branch;
    }

    public SchemaManager copyWithBranch(String branchName) {
        return new SchemaManager(this.fileIO, this.tableRoot, branchName);
    }

    public SchemaManager withLock(@Nullable Lock lock) {
        this.lock = lock;
        return this;
    }

    public Optional<TableSchema> latest() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).reduce(Math::max).map(this::schema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<TableSchema> listAll() {
        return this.listAllIds().stream().map(this::schema).collect(Collectors.toList());
    }

    public List<Long> listAllIds() {
        try {
            return FileUtils.listVersionedFiles(this.fileIO, this.schemaDirectory(), SCHEMA_PREFIX).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public TableSchema createTable(Schema schema) throws Exception {
        return this.createTable(schema, false);
    }

    public TableSchema createTable(Schema schema, boolean ignoreIfExistsSame) throws Exception {
        Map<String, String> options;
        List<String> primaryKeys;
        List<String> partitionKeys;
        int highestFieldId;
        List<DataField> fields;
        TableSchema newSchema;
        boolean success;
        do {
            Optional<TableSchema> latest;
            if ((latest = this.latest()).isPresent()) {
                boolean isSame;
                TableSchema oldSchema = latest.get();
                boolean bl = isSame = Objects.equals(oldSchema.fields(), schema.fields()) && Objects.equals(oldSchema.partitionKeys(), schema.partitionKeys()) && Objects.equals(oldSchema.primaryKeys(), schema.primaryKeys()) && Objects.equals(oldSchema.options(), schema.options());
                if (ignoreIfExistsSame && isSame) {
                    return oldSchema;
                }
                throw new IllegalStateException("Schema in filesystem exists, please use updating, latest schema is: " + oldSchema);
            }
            fields = schema.fields();
            partitionKeys = schema.partitionKeys();
            primaryKeys = schema.primaryKeys();
            options = schema.options();
        } while (!(success = this.commit(newSchema = new TableSchema(0L, fields, highestFieldId = RowType.currentHighestFieldId(fields), partitionKeys, primaryKeys, options, schema.comment()))));
        return newSchema;
    }

    public TableSchema commitChanges(SchemaChange ... changes) throws Exception {
        return this.commitChanges(Arrays.asList(changes));
    }

    /*
     * Exception decompiling
     */
    public TableSchema commitChanges(List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void applyMove(List<DataField> newFields, SchemaChange.Move move) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < newFields.size(); ++i) {
            map.put(newFields.get(i).name(), i);
        }
        int fieldIndex = map.getOrDefault(move.fieldName(), -1);
        if (fieldIndex == -1) {
            throw new IllegalArgumentException("Field name not found: " + move.fieldName());
        }
        switch (move.type()) {
            case FIRST: {
                SchemaManager.checkMoveIndexEqual(move, fieldIndex, 0);
                this.moveField(newFields, fieldIndex, 0);
                return;
            }
            case LAST: {
                SchemaManager.checkMoveIndexEqual(move, fieldIndex, newFields.size() - 1);
                this.moveField(newFields, fieldIndex, newFields.size() - 1);
                return;
            }
        }
        Integer refIndex = map.getOrDefault(move.referenceFieldName(), -1);
        if (refIndex == -1) {
            throw new IllegalArgumentException("Reference field name not found: " + move.referenceFieldName());
        }
        SchemaManager.checkMoveIndexEqual(move, fieldIndex, refIndex);
        int targetIndex = refIndex;
        if (move.type() == SchemaChange.Move.MoveType.AFTER && fieldIndex > refIndex) {
            ++targetIndex;
        }
        if (move.type() == SchemaChange.Move.MoveType.BEFORE && fieldIndex < refIndex) {
            --targetIndex;
        }
        if (targetIndex > newFields.size() - 1) {
            targetIndex = newFields.size() - 1;
        }
        this.moveField(newFields, fieldIndex, targetIndex);
    }

    private void moveField(List<DataField> newFields, int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= newFields.size() || toIndex < 0) {
            return;
        }
        DataField fieldToMove = newFields.remove(fromIndex);
        newFields.add(toIndex, fieldToMove);
    }

    private static void checkMoveIndexEqual(SchemaChange.Move move, int fieldIndex, int refIndex) {
        if (refIndex == fieldIndex) {
            throw new UnsupportedOperationException(String.format("Cannot move itself for column %s", move.fieldName()));
        }
    }

    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        TableSchema update;
        TableSchema current = this.latest().orElseThrow(() -> new RuntimeException("It requires that the current schema to exist when calling 'mergeSchema'"));
        if (current.equals(update = SchemaMergingUtils.mergeSchemas(current, rowType, allowExplicitCast))) {
            return false;
        }
        try {
            return this.commit(update);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit the schema.", e);
        }
    }

    private void validateNotPrimaryAndPartitionKey(TableSchema schema, String fieldName) {
        if (schema.partitionKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot drop/rename partition key[%s]", fieldName));
        }
        if (schema.primaryKeys().contains(fieldName)) {
            throw new UnsupportedOperationException(String.format("Cannot drop/rename primary key[%s]", fieldName));
        }
    }

    private void updateNestedColumn(List<DataField> newFields, String[] updateFieldNames, int index, Function<DataField, DataField> updateFunc) throws Catalog.ColumnNotExistException {
        boolean found = false;
        for (int i = 0; i < newFields.size(); ++i) {
            DataField field = newFields.get(i);
            if (!field.name().equals(updateFieldNames[index])) continue;
            found = true;
            if (index == updateFieldNames.length - 1) {
                newFields.set(i, updateFunc.apply(field));
                break;
            }
            ArrayList<DataField> nestedFields = new ArrayList<DataField>(((RowType)field.type()).getFields());
            this.updateNestedColumn(nestedFields, updateFieldNames, index + 1, updateFunc);
            newFields.set(i, new DataField(field.id(), field.name(), new RowType(field.type().isNullable(), nestedFields), field.description()));
        }
        if (!found) {
            throw new Catalog.ColumnNotExistException(SchemaManager.identifierFromPath(this.tableRoot.toString(), true, this.branch), Arrays.toString(updateFieldNames));
        }
    }

    private void updateColumn(List<DataField> newFields, String updateFieldName, Function<DataField, DataField> updateFunc) throws Catalog.ColumnNotExistException {
        this.updateNestedColumn(newFields, new String[]{updateFieldName}, 0, updateFunc);
    }

    @VisibleForTesting
    boolean commit(TableSchema newSchema) throws Exception {
        SchemaValidation.validateTableSchema(newSchema);
        SchemaValidation.validateFallbackBranch(this, newSchema);
        Path schemaPath = this.toSchemaPath(newSchema.id());
        Callable<Boolean> callable = () -> this.fileIO.tryToWriteAtomic(schemaPath, newSchema.toString());
        if (this.lock == null) {
            return callable.call();
        }
        return this.lock.runWithLock(callable);
    }

    public TableSchema schema(long id) {
        try {
            return JsonSerdeUtil.fromJson(this.fileIO.readFileUtf8(this.toSchemaPath(id)), TableSchema.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean schemaExists(long id) {
        Path path = this.toSchemaPath(id);
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if schema '%s' exists in path %s.", id, path), e);
        }
    }

    public static TableSchema fromPath(FileIO fileIO, Path path) {
        try {
            return JsonSerdeUtil.fromJson(fileIO.readFileUtf8(path), TableSchema.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String branchPath() {
        return BranchManager.branchPath(this.tableRoot, this.branch);
    }

    public Path schemaDirectory() {
        return new Path(this.branchPath() + "/schema");
    }

    @VisibleForTesting
    public Path toSchemaPath(long schemaId) {
        return new Path(this.branchPath() + "/schema/" + SCHEMA_PREFIX + schemaId);
    }

    public void deleteSchema(long schemaId) {
        this.fileIO.deleteQuietly(this.toSchemaPath(schemaId));
    }

    public static void checkAlterTableOption(String key, @Nullable String oldValue, String newValue, boolean fromDynamicOptions) {
        if (CoreOptions.IMMUTABLE_OPTIONS.contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
        if (CoreOptions.BUCKET.key().equals(key)) {
            int oldBucket = oldValue == null ? CoreOptions.BUCKET.defaultValue() : Integer.parseInt(oldValue);
            int newBucket = Integer.parseInt(newValue);
            if (fromDynamicOptions) {
                throw new UnsupportedOperationException("Cannot change bucket number through dynamic options. You might need to rescale bucket.");
            }
            if (oldBucket == -1) {
                throw new UnsupportedOperationException("Cannot change bucket when it is -1.");
            }
            if (newBucket == -1) {
                throw new UnsupportedOperationException("Cannot change bucket to -1.");
            }
        }
    }

    public static void checkResetTableOption(String key) {
        if (CoreOptions.IMMUTABLE_OPTIONS.contains(key)) {
            throw new UnsupportedOperationException(String.format("Change '%s' is not supported yet.", key));
        }
        if (CoreOptions.BUCKET.key().equals(key)) {
            throw new UnsupportedOperationException(String.format("Cannot reset %s.", key));
        }
    }

    public static void checkAlterTablePath(String key) {
        if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
            throw new UnsupportedOperationException("Change path is not supported yet.");
        }
    }

    public static Identifier identifierFromPath(String tablePath, boolean ignoreIfUnknownDatabase) {
        return SchemaManager.identifierFromPath(tablePath, ignoreIfUnknownDatabase, null);
    }

    public static Identifier identifierFromPath(String tablePath, boolean ignoreIfUnknownDatabase, @Nullable String branchName) {
        String[] paths;
        if ("main".equals(branchName)) {
            branchName = null;
        }
        if ((paths = tablePath.split("/")).length < 2) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a valid path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[0]);
        }
        String database = paths[paths.length - 2];
        int index = database.lastIndexOf(".db");
        if (index == -1) {
            if (!ignoreIfUnknownDatabase) {
                throw new IllegalArgumentException(String.format("Path '%s' is not a valid path, please use catalog table path instead: 'warehouse_path/your_database.db/your_table'.", tablePath));
            }
            return new Identifier("unknown", paths[paths.length - 1], branchName, null);
        }
        database = database.substring(0, index);
        return new Identifier(database, paths[paths.length - 1], branchName, null);
    }

    private static /* synthetic */ DataField lambda$commitChanges$7(SchemaChange.UpdateColumnComment update, DataField field) {
        return new DataField(field.id(), field.name(), field.type(), update.newDescription());
    }

    private static /* synthetic */ DataField lambda$commitChanges$6(SchemaChange.UpdateColumnNullability update, DataField field) {
        return new DataField(field.id(), field.name(), field.type().copy(update.newNullability()), field.description());
    }

    private static /* synthetic */ DataField lambda$commitChanges$5(SchemaChange.UpdateColumnType update, DataField field) {
        DataType targetType = update.newDataType();
        if (update.keepNullability()) {
            targetType = targetType.copy(field.type().isNullable());
        }
        Preconditions.checkState(DataTypeCasts.supportsExplicitCast(field.type(), targetType) && CastExecutors.resolve(field.type(), targetType) != null, String.format("Column type %s[%s] cannot be converted to %s without loosing information.", field.name(), field.type(), targetType));
        AtomicInteger dummyId = new AtomicInteger(0);
        if (dummyId.get() != 0) {
            throw new RuntimeException(String.format("Update column to nested row type '%s' is not supported.", targetType));
        }
        return new DataField(field.id(), field.name(), targetType, field.description());
    }

    private static /* synthetic */ boolean lambda$commitChanges$4(SchemaChange change, DataField f) {
        return f.name().equals(((SchemaChange.DropColumn)change).fieldName());
    }

    private static /* synthetic */ DataField lambda$commitChanges$3(SchemaChange.RenameColumn rename, DataField field) {
        return new DataField(field.id(), rename.newName(), field.type(), field.description());
    }

    private static /* synthetic */ boolean lambda$commitChanges$2(SchemaChange.RenameColumn rename, DataField f) {
        return f.name().equals(rename.newName());
    }

    private static /* synthetic */ boolean lambda$commitChanges$1(SchemaChange.AddColumn addColumn, DataField f) {
        return f.name().equals(addColumn.fieldName());
    }

    private /* synthetic */ Catalog.TableNotExistException lambda$commitChanges$0() {
        return new Catalog.TableNotExistException(SchemaManager.identifierFromPath(this.tableRoot.toString(), true, this.branch));
    }
}

