/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileMerger {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFileMerger.class);

    public static List<ManifestFileMeta> merge(List<ManifestFileMeta> input, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount, long manifestFullCompactionSize, RowType partitionType, @Nullable Integer manifestReadParallelism) {
        ArrayList<ManifestFileMeta> newMetas = new ArrayList<ManifestFileMeta>();
        try {
            Optional<List<ManifestFileMeta>> fullCompacted = ManifestFileMerger.tryFullCompaction(input, newMetas, manifestFile, suggestedMetaSize, manifestFullCompactionSize, partitionType, manifestReadParallelism);
            return fullCompacted.orElseGet(() -> ManifestFileMerger.tryMinorCompaction(input, newMetas, manifestFile, suggestedMetaSize, suggestedMinMetaCount, manifestReadParallelism));
        }
        catch (Throwable e) {
            for (ManifestFileMeta manifest : newMetas) {
                manifestFile.delete(manifest.fileName());
            }
            throw new RuntimeException(e);
        }
    }

    private static List<ManifestFileMeta> tryMinorCompaction(List<ManifestFileMeta> input, List<ManifestFileMeta> newMetas, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount, @Nullable Integer manifestReadParallelism) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        ArrayList<ManifestFileMeta> candidates = new ArrayList<ManifestFileMeta>();
        long totalSize = 0L;
        for (ManifestFileMeta manifest : input) {
            candidates.add(manifest);
            if ((totalSize += manifest.fileSize()) < suggestedMetaSize) continue;
            ManifestFileMerger.mergeCandidates(candidates, manifestFile, result, newMetas, manifestReadParallelism);
            candidates.clear();
            totalSize = 0L;
        }
        if (candidates.size() >= suggestedMinMetaCount) {
            ManifestFileMerger.mergeCandidates(candidates, manifestFile, result, newMetas, manifestReadParallelism);
        } else {
            result.addAll(candidates);
        }
        return result;
    }

    private static void mergeCandidates(List<ManifestFileMeta> candidates, ManifestFile manifestFile, List<ManifestFileMeta> result, List<ManifestFileMeta> newMetas, @Nullable Integer manifestReadParallelism) {
        if (candidates.size() == 1) {
            result.add(candidates.get(0));
            return;
        }
        LinkedHashMap<FileEntry.Identifier, ManifestEntry> map = new LinkedHashMap<FileEntry.Identifier, ManifestEntry>();
        FileEntry.mergeEntries(manifestFile, candidates, map, manifestReadParallelism);
        if (!map.isEmpty()) {
            List<ManifestFileMeta> merged = manifestFile.write(new ArrayList<ManifestEntry>(map.values()));
            result.addAll(merged);
            newMetas.addAll(merged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<List<ManifestFileMeta>> tryFullCompaction(List<ManifestFileMeta> inputs, List<ManifestFileMeta> newMetas, ManifestFile manifestFile, long suggestedMetaSize, long sizeTrigger, RowType partitionType, @Nullable Integer manifestReadParallelism) throws Exception {
        ManifestFileMeta file;
        int j;
        ManifestFileMeta file2;
        int i;
        ArrayList<ManifestFileMeta> base = new ArrayList<ManifestFileMeta>();
        long totalManifestSize = 0L;
        for (i = 0; i < inputs.size() && (file2 = inputs.get(i)).numDeletedFiles() == 0L && file2.fileSize() >= suggestedMetaSize; ++i) {
            base.add(file2);
            totalManifestSize += file2.fileSize();
        }
        ArrayList<ManifestFileMeta> delta = new ArrayList<ManifestFileMeta>();
        long deltaDeleteFileNum = 0L;
        long totalDeltaFileSize = 0L;
        while (i < inputs.size()) {
            ManifestFileMeta file3 = inputs.get(i);
            delta.add(file3);
            totalManifestSize += file3.fileSize();
            deltaDeleteFileNum += file3.numDeletedFiles();
            totalDeltaFileSize += file3.fileSize();
            ++i;
        }
        if (totalDeltaFileSize < sizeTrigger) {
            return Optional.empty();
        }
        LOG.info("Start Manifest File Full Compaction, pick the number of delete file: {}, total manifest file size: {}", (Object)deltaDeleteFileNum, (Object)totalManifestSize);
        LinkedHashMap<FileEntry.Identifier, ManifestEntry> deltaMerged = new LinkedHashMap<FileEntry.Identifier, ManifestEntry>();
        FileEntry.mergeEntries(manifestFile, delta, deltaMerged, manifestReadParallelism);
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        if (partitionType.getFieldCount() > 0) {
            Set<BinaryRow> deletePartitions = ManifestFileMerger.computeDeletePartitions(deltaMerged);
            PartitionPredicate predicate = PartitionPredicate.fromMultiple(partitionType, deletePartitions);
            if (predicate != null) {
                for (j = 0; j < base.size() && !predicate.test((file = (ManifestFileMeta)base.get(j)).numAddedFiles() + file.numDeletedFiles(), file.partitionStats().minValues(), file.partitionStats().maxValues(), file.partitionStats().nullCounts()); ++j) {
                    result.add(file);
                }
            } else {
                j = base.size();
                result.addAll(base);
            }
        }
        HashSet deleteEntries = new HashSet();
        deltaMerged.forEach((k, v) -> {
            if (v.kind() == FileKind.DELETE) {
                deleteEntries.add(k);
            }
        });
        ArrayList<ManifestEntry> mergedEntries = new ArrayList<ManifestEntry>();
        while (j < base.size()) {
            file = (ManifestFileMeta)base.get(j);
            boolean contains = false;
            for (ManifestEntry entry : manifestFile.read(file.fileName(), file.fileSize())) {
                Preconditions.checkArgument(entry.kind() == FileKind.ADD);
                if (deleteEntries.contains(entry.identifier())) {
                    contains = true;
                    continue;
                }
                mergedEntries.add(entry);
            }
            if (contains) {
                ++j;
                break;
            }
            mergedEntries.clear();
            result.add(file);
            ++j;
        }
        RollingFileWriter<ManifestEntry, ManifestFileMeta> writer = manifestFile.createRollingWriter();
        Exception exception = null;
        try {
            for (ManifestEntry entry : mergedEntries) {
                writer.write(entry);
            }
            mergedEntries.clear();
            for (ManifestEntry entry : FileEntry.readManifestEntries(manifestFile, base.subList(j, base.size()), manifestReadParallelism)) {
                Preconditions.checkArgument(entry.kind() == FileKind.ADD);
                if (deleteEntries.contains(entry.identifier())) continue;
                writer.write(entry);
            }
            for (ManifestEntry entry : deltaMerged.values()) {
                if (entry.kind() != FileKind.ADD) continue;
                writer.write(entry);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                IOUtils.closeQuietly(writer);
                throw exception;
            }
            writer.close();
        }
        Object merged = writer.result();
        result.addAll((Collection<ManifestFileMeta>)merged);
        newMetas.addAll((Collection<ManifestFileMeta>)merged);
        return Optional.of(result);
    }

    private static Set<BinaryRow> computeDeletePartitions(Map<FileEntry.Identifier, ManifestEntry> deltaMerged) {
        HashSet<BinaryRow> partitions = new HashSet<BinaryRow>();
        for (ManifestEntry manifestEntry : deltaMerged.values()) {
            if (manifestEntry.kind() != FileKind.DELETE) continue;
            BinaryRow partition = manifestEntry.partition();
            partitions.add(partition);
        }
        return partitions;
    }
}

