/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.append.AppendOnlyWriter;
import org.apache.paimon.append.BucketedAppendCompactManager;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.NoopCompactManager;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.RowDataRollingFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.BundleFileStoreWriter;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.MemoryFileStoreWrite;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.ExceptionUtils;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.IOExceptionSupplier;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StatsCollectorFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyFileStoreWrite
extends MemoryFileStoreWrite<InternalRow>
implements BundleFileStoreWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyFileStoreWrite.class);
    private final FileIO fileIO;
    private final RawFileSplitRead read;
    private final long schemaId;
    private final RowType rowType;
    private final FileFormat fileFormat;
    private final FileStorePathFactory pathFactory;
    private final long targetFileSize;
    private final int compactionMinFileNum;
    private final int compactionMaxFileNum;
    private final boolean commitForceCompact;
    private final String fileCompression;
    private final CompressOptions spillCompression;
    private final boolean useWriteBuffer;
    private final boolean spillable;
    private final MemorySize maxDiskSize;
    private final SimpleColStatsCollector.Factory[] statsCollectors;
    private final FileIndexOptions fileIndexOptions;
    private final BucketMode bucketMode;
    private boolean forceBufferSpill = false;
    private final boolean skipCompaction;

    public AppendOnlyFileStoreWrite(FileIO fileIO, RawFileSplitRead read, long schemaId, String commitUser, RowType rowType, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options, BucketMode bucketMode, @Nullable DeletionVectorsMaintainer.Factory dvMaintainerFactory, String tableName) {
        super(commitUser, snapshotManager, scan, options, null, dvMaintainerFactory, tableName);
        this.fileIO = fileIO;
        this.read = read;
        this.schemaId = schemaId;
        this.rowType = rowType;
        this.fileFormat = options.fileFormat();
        this.pathFactory = pathFactory;
        this.bucketMode = bucketMode;
        this.targetFileSize = options.targetFileSize(false);
        this.compactionMinFileNum = options.compactionMinFileNum();
        this.compactionMaxFileNum = options.compactionMaxFileNum().orElse(5);
        this.commitForceCompact = options.commitForceCompact();
        if (bucketMode == BucketMode.BUCKET_UNAWARE) {
            super.withIgnorePreviousFiles(true);
            this.skipCompaction = true;
        } else {
            this.skipCompaction = options.writeOnly();
        }
        this.fileCompression = options.fileCompression();
        this.spillCompression = options.spillCompressOptions();
        this.useWriteBuffer = options.useWriteBufferForAppend();
        this.spillable = options.writeBufferSpillable(fileIO.isObjectStore(), this.isStreamingMode);
        this.maxDiskSize = options.writeBufferSpillDiskSize();
        this.statsCollectors = StatsCollectorFactories.createStatsFactories(options, rowType.getFieldNames());
        this.fileIndexOptions = options.indexColumnsOptions();
    }

    @Override
    protected RecordWriter<InternalRow> createWriter(@Nullable Long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> restoredFiles, long restoredMaxSeqNumber, @Nullable CommitIncrement restoreIncrement, ExecutorService compactExecutor, @Nullable DeletionVectorsMaintainer dvMaintainer) {
        CompactManager compactManager = new NoopCompactManager();
        if (!this.skipCompaction) {
            Function<String, DeletionVector> dvFactory = dvMaintainer != null ? f -> dvMaintainer.deletionVectorOf((String)f).orElse(null) : null;
            compactManager = new BucketedAppendCompactManager(compactExecutor, restoredFiles, dvMaintainer, this.compactionMinFileNum, this.compactionMaxFileNum, this.targetFileSize, files -> this.compactRewrite(partition, bucket, dvFactory, files), this.compactionMetrics == null ? null : this.compactionMetrics.createReporter(partition, bucket));
        }
        return new AppendOnlyWriter(this.fileIO, this.ioManager, this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, restoredMaxSeqNumber, compactManager, files -> this.createFilesIterator(partition, bucket, (List<DataFileMeta>)files, null), this.commitForceCompact, this.pathFactory.createDataFilePathFactory(partition, bucket), restoreIncrement, this.useWriteBuffer || this.forceBufferSpill, this.spillable || this.forceBufferSpill, this.fileCompression, this.spillCompression, this.statsCollectors, this.maxDiskSize, this.fileIndexOptions, this.options.asyncFileWrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataFileMeta> compactRewrite(BinaryRow partition, int bucket, @Nullable Function<String, DeletionVector> dvFactory, List<DataFileMeta> toCompact) throws Exception {
        if (toCompact.isEmpty()) {
            return Collections.emptyList();
        }
        Exception collectedExceptions = null;
        RowDataRollingFileWriter rewriter = this.createRollingFileWriter(partition, bucket, new LongCounter(toCompact.get(0).minSequenceNumber()), FileSource.COMPACT);
        ArrayList<IOExceptionSupplier<DeletionVector>> dvFactories = null;
        if (dvFactory != null) {
            dvFactories = new ArrayList<IOExceptionSupplier<DeletionVector>>(toCompact.size());
            for (DataFileMeta file : toCompact) {
                dvFactories.add(() -> (DeletionVector)dvFactory.apply(file.fileName()));
            }
        }
        try {
            rewriter.write(this.createFilesIterator(partition, bucket, toCompact, dvFactories));
        }
        catch (Exception e) {
            collectedExceptions = e;
        }
        finally {
            try {
                rewriter.close();
            }
            catch (Exception e) {
                collectedExceptions = ExceptionUtils.firstOrSuppressed(e, collectedExceptions);
            }
        }
        if (collectedExceptions != null) {
            throw collectedExceptions;
        }
        return rewriter.result();
    }

    private RowDataRollingFileWriter createRollingFileWriter(BinaryRow partition, int bucket, LongCounter seqNumCounter, FileSource fileSource) {
        return new RowDataRollingFileWriter(this.fileIO, this.schemaId, this.fileFormat, this.targetFileSize, this.rowType, this.pathFactory.createDataFilePathFactory(partition, bucket), seqNumCounter, this.fileCompression, this.statsCollectors, this.fileIndexOptions, fileSource, this.options.asyncFileWrite());
    }

    private RecordReaderIterator<InternalRow> createFilesIterator(BinaryRow partition, int bucket, List<DataFileMeta> files, @Nullable List<IOExceptionSupplier<DeletionVector>> dvFactories) throws IOException {
        return new RecordReaderIterator<InternalRow>(this.read.createReader(partition, bucket, files, dvFactories));
    }

    @Override
    public void withIgnorePreviousFiles(boolean ignorePrevious) {
        super.withIgnorePreviousFiles(ignorePrevious || this.bucketMode == BucketMode.BUCKET_UNAWARE);
    }

    @Override
    protected void forceBufferSpill() throws Exception {
        if (this.ioManager == null) {
            return;
        }
        this.forceBufferSpill = true;
        LOG.info("Force buffer spill for append-only file store write, writer number is: {}", (Object)this.writers.size());
        for (Map bucketWriters : this.writers.values()) {
            for (AbstractFileStoreWrite.WriterContainer writerContainer : bucketWriters.values()) {
                ((AppendOnlyWriter)writerContainer.writer).toBufferedWriter();
            }
        }
    }

    @Override
    public void writeBundle(BinaryRow partition, int bucket, BundleRecords bundle) throws Exception {
        AbstractFileStoreWrite.WriterContainer container = this.getWriterWrapper(partition, bucket);
        ((AppendOnlyWriter)container.writer).writeBundle(bundle);
    }
}

