/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.sort.SortContext;
import org.apache.paimon.lookup.sort.SortLookupStoreReader;
import org.apache.paimon.lookup.sort.SortLookupStoreWriter;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.utils.BloomFilter;

public class SortLookupStoreFactory
implements LookupStoreFactory {
    private final Comparator<MemorySlice> comparator;
    private final CacheManager cacheManager;
    private final int blockSize;
    @Nullable
    private final BlockCompressionFactory compressionFactory;

    public SortLookupStoreFactory(Comparator<MemorySlice> comparator, CacheManager cacheManager, int blockSize, CompressOptions compression) {
        this.comparator = comparator;
        this.cacheManager = cacheManager;
        this.blockSize = blockSize;
        this.compressionFactory = BlockCompressionFactory.create(compression);
    }

    @Override
    public SortLookupStoreReader createReader(File file, LookupStoreFactory.Context context) throws IOException {
        return new SortLookupStoreReader(this.comparator, file, (SortContext)context, this.cacheManager);
    }

    @Override
    public SortLookupStoreWriter createWriter(File file, @Nullable BloomFilter.Builder bloomFilter) throws IOException {
        return new SortLookupStoreWriter(file, this.blockSize, bloomFilter, this.compressionFactory);
    }
}

