/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.IOException;
import org.apache.paimon.lookup.sort.BlockAlignedType;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceOutput;
import org.apache.paimon.utils.IntArrayList;

public class BlockWriter {
    private final IntArrayList positions = new IntArrayList(32);
    private final MemorySliceOutput block;
    private int alignedSize;
    private boolean aligned;

    public BlockWriter(int blockSize) {
        this.block = new MemorySliceOutput(blockSize + 128);
        this.alignedSize = 0;
        this.aligned = true;
    }

    public void reset() {
        this.positions.clear();
        this.block.reset();
        this.alignedSize = 0;
        this.aligned = true;
    }

    public void add(byte[] key, byte[] value) {
        int startPosition = this.block.size();
        this.block.writeVarLenInt(key.length);
        this.block.writeBytes(key);
        this.block.writeVarLenInt(value.length);
        this.block.writeBytes(value);
        int endPosition = this.block.size();
        this.positions.add(startPosition);
        if (this.aligned) {
            int currentSize = endPosition - startPosition;
            if (this.alignedSize == 0) {
                this.alignedSize = currentSize;
            } else {
                this.aligned = this.alignedSize == currentSize;
            }
        }
    }

    public int size() {
        return this.positions.size();
    }

    public int memory() {
        int memory = this.block.size() + 5;
        if (!this.aligned) {
            memory += this.positions.size() * 4;
        }
        return memory;
    }

    public MemorySlice finish() throws IOException {
        if (this.positions.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.aligned) {
            this.block.writeInt(this.alignedSize);
        } else {
            for (int i = 0; i < this.positions.size(); ++i) {
                this.block.writeInt(this.positions.get(i));
            }
            this.block.writeInt(this.positions.size());
        }
        this.block.writeByte(this.aligned ? BlockAlignedType.ALIGNED.toByte() : BlockAlignedType.UNALIGNED.toByte());
        return this.block.toSlice();
    }
}

